unit TextConvert;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls,
  FileAssigning;


// Konvertiert den Text Chapter-File fr Chapter-File
procedure ConvertChapter (stSrc,stDest : string;log,bibel : TStrings);
function ASCIIConvert (cData : char) : char;

implementation

type TStatus = (Text,Kapitel,Vers);
     TReturnStatus = (RText,RSingleReturn,RReturn);

procedure ConvertChapter (stSrc,stDest : string;log,bibel : TStrings);
var cData : Char;
    szInBuf,szOutBuf : array [0..cBufferSize] of char;
    hIn,hOut : THandle;
    blBreak,blWrite : Boolean;
    iRead,iReadPos : integer;
    iTemp,iWritten,iWritePos : Integer;
    Status : TStatus;
    ReturnStatus : TReturnStatus;
begin
     strpcopy (szInBuf,stSrc);

     // Dateien ffnen
     hIn := CreateFile (szInBuf,GENERIC_READ,FILE_SHARE_READ,Nil,
                        OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL or FILE_FLAG_SEQUENTIAL_SCAN,
                        0);
     if hIn = INVALID_HANDLE_VALUE then begin
        Log.Add ('Datei '+ stSrc + ' kann nicht geffnet werden!');
        Log.Add ('Beende Verarbeitung von ' + stSrc);
     end else begin
        strpcopy (szInBuf,stDest);
        hOut := CreateFile (szInBuf,GENERIC_WRITE,FILE_SHARE_READ,Nil,
                           CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL or FILE_FLAG_SEQUENTIAL_SCAN,
                           0);
        if hOut = INVALID_HANDLE_VALUE then begin
           Log.Add ('Datei '+ stDest + ' kann nicht geffnet werden!');
           Log.Add ('Beende Verarbeitung von ' + stSrc);
        end else begin
           Log.Add ('Loading ' + stSrc);

           // Zeichen fr Zeichen der Datei laden, konvertieren, bearbeiten und speichern

           blBreak := FALSE;
           iWritePos := 0;
           Status := Text;

           while blBreak = FALSE do
           begin
              // Datenbuffer fllen:
              ReadFile (hIn,szInBuf,cBufferSize,iRead,Nil);

              if iRead = 0 then begin
                 blBreak := TRUE;
              end else begin

                 // Gelesenen Datenpuffer bearbeiten:
                 for iReadPos := 0 to iRead do begin

                    // ASCII- Konvertierung vornehmen:
                    cData := ASCIIConvert (szInBuf[iReadPos]);

                    // Schreiben ein/aus -Voreinstellung nach Status
                    if (Status = Kapitel) or (Status = Vers) then
                    begin
                       blWrite := FALSE;
                    end else begin
                       blWrite := TRUE;
                    end;

                    // Returns bearbeiten
                    // nur das 2. Return kommt durch!
                    if (cData = char ($0a)) or (cData = char ($0d)) then
                    begin
                       if ReturnStatus = RSingleReturn then
                       begin
                          ReturnStatus := RReturn;
                       end else begin
                          blWrite := FALSE;
                          if ReturnStatus = RText then begin // Space statt Return:
                             ReturnStatus := RSingleReturn;
                          end;
                       end;
                    end else begin
                        ReturnStatus := RText;
                    end;

                    // Kapitelkennzeichnung bearbeiten
                    if cData = '\' then
                    begin
                       if Status = Text then
                       begin
                          Status := Kapitel;
                          cData := char ($0a);
                       end else begin
                          Status := Text;
                       end;
                    end;

                    // Verskennzeichnung bearbeiten
                    if cData = '$' then
                    begin
                       if Status = Text then
                       begin
                          Status := Vers;
                          blWrite := FALSE;
                       end else begin
                          Status := Text;
                       end
                    end;

                    // ermitteln, ob Byte geschrieben werden darf:
                    if blWrite = TRUE then
                    begin
                       // Datum schreiben:
                       szOutBuf [iWritePos] := cData;
                       iWritePos := iWritePos +1;
                       // Ist der Out-Buffer voll?
                       if iWritePos >= cBufferSize then
                       begin        // ja: Buffer leeren
                           WriteFile (hOut,szOutBuf,iWritePos -1,iTemp,Nil);
                           iWritePos := 0;
                       end; // if iWritePos >= cBufferSize then

                    end;

                 end; // for iReadPos := 0 to cBufferSize do begin
              end; // else if iRead = 0 then begin


           end; // while blBreak = FALSE do

           // vor dem schlieen Out-Buffer leeren:
           if iWritePos > 0 then
           begin
              WriteFile (hOut,szOutBuf,iWritePos -1,iTemp,Nil);
              iWritePos := 0;
           end;


           CloseHandle (hOut);
        end; // else if hOut
        CloseHandle (hIn)
     end; // else if hIn ...

end;

function ASCIIConvert (cData : char) : char;
begin

   case Integer(cData) of
      $84 :   ASCIIConvert := '';
      $94 :   ASCIIConvert := '';
      $81 :   ASCIIConvert := '';
      $8e :   ASCIIConvert := '';
      $99 :   ASCIIConvert := '';
      $9a :   ASCIIConvert := '';
      $e1 :   ASCIIConvert := '';

      else    ASCIIConvert := cData;
   end;

end;


end.
