unit UMyRichEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls,RichEdit;

type
  TMyRichEdit = class(TWinControl)
  private
    { Private-Deklarationen }
    FLibHandle : THandle;

    procedure WMNCDestroy(var Message: TWMNCDestroy); message WM_NCDESTROY;

  protected
    { Protected-Deklarationen }
    procedure CreateParams(var Params: TCreateParams); override;
    function GetLines : Integer;
    function GetFirstLine : Integer;
    procedure SetFirstLine (iPos : Integer);


  public
    { Public-Deklarationen }
    procedure LoadFromFile(const cstFileName: string);
    procedure SaveToFile(const cstFileName: string);

    // EIgenschaften zur Laufzeit
    property Lines : Integer read GetLines;
    property FirstLine : Integer read GetFirstLine write SetFirstLine;


  published
    { Published-Deklarationen }

    // geerbte Eigenschaften:
    property Ctl3D;
    property HelpContext;
    property ParentCtl3D;

    // Geerbte Ereignisse:
    property OnExit;
    property OnEnter;
    property OnKeyDown;
    property OnKeyUp;
    property OnKeyPress;


  end;

procedure Register;

implementation

// Callback Funktion zum Speichern von RTF-Daten
function StreamSave(dwCookie: Longint; pbBuff: PByte;
  cb: Longint; var pcb: DWORD): Longint; stdcall;
begin
     WriteFile (THandle (dwCookie),pbBuff^,cb,pcb,Nil);
     StreamSave := 0;
end;

// Callback- Funktion zum laden von Streams
function StreamLoad(dwCookie: Longint; pbBuff: PByte;
  cb: LongInt; var pcb: DWORD): Longint; stdcall;
var h : THandle;
begin
     h := THandle (dwCookie);
     ReadFile (h,pbBuff^,cb,pcb,Nil);
     if pcb < cb then
        StreamLoad := 1
     else
        StreamLoad := 0;
end;


// Ladefunktion berladen, um Datei 1:1 einlesen zu knnen, und evt.
// zu komprimieren
procedure TMyRichEdit.LoadFromFile(const cstFileName: string);
var hFile : THandle;
    szBuf : array [0..MAX_PATH] of char;
    oStream : TEditStream;
begin
   // Dateinamen konvertieren
   strpcopy (szBuf,cstFileName);

   // Datei ffnen
   hFile := CreateFile (szBuf,
                        GENERIC_READ,
                        0,
                        NIL,
                        OPEN_EXISTING,
                        FILE_FLAG_SEQUENTIAL_SCAN,
                        0);

   if hFile = INVALID_HANDLE_VALUE then begin
      raise EFOpenError (cstFileName);
   end;

   // Datenstruktur fr Serialization zusammenstellen:
   with oStream do begin
      dwCookie := hFile;
      pfnCallback := @StreamLoad;
      dwError := 0;
   end;

   SendMessage (Handle,EM_STREAMIN,SF_RTF,LongInt (@oStream));
   SendMessage (Handle,EM_SETMODIFY,WPARAM (TRUE),0);

   CloseHandle (hFile);

end;

procedure TMyRichEdit.SaveToFile(const cstFileName: string);
var hFile : THandle;
    szBuf : array [0..MAX_PATH] of char;
    oStream : TEditStream;
begin
   // Dateinamen konvertieren
   strpcopy (szBuf,cstFileName);

   // Datei ffnen
   hFile := CreateFile (szBuf,
                        GENERIC_WRITE,
                        0,
                        NIL,
                        CREATE_ALWAYS,
                        FILE_FLAG_SEQUENTIAL_SCAN,
                        0);

   if hFile = INVALID_HANDLE_VALUE then begin
      raise EFOpenError (cstFileName);
   end;

   // Datenstruktur fr Serialization zusammenstellen:
   with oStream do begin
      dwCookie := hFile;
      pfnCallback := @StreamSave;
      dwError := 0;
   end;

   SendMessage (Handle,EM_STREAMOUT,SF_RTF,LongInt (@oStream));

   CloseHandle (hFile);

end;

procedure TMyRichEdit.CreateParams(var Params: TCreateParams);
const
  RichEditModuleName = 'RICHED32.DLL';
  HideScrollBars: array[Boolean] of Longint = (ES_DISABLENOSCROLL, 0);
  HideSelections: array[Boolean] of Longint = (ES_NOHIDESEL, 0);
var
  OldError: Longint;
begin
  OldError := SetErrorMode(SEM_NOOPENFILEERRORBOX);
  FLibHandle := LoadLibrary(RichEditModuleName);
  if FLibHandle < HINSTANCE_ERROR then FLibHandle := 0;
  SetErrorMode(OldError);
  inherited CreateParams(Params);
  CreateSubClass(Params, 'RICHEDIT');
  with Params do begin
     ExStyle := WS_EX_CLIENTEDGE or WS_EX_CONTROLPARENT;
     Style := WS_CHILD or WS_VISIBLE {or WS_VSCROLL} or ES_MULTILINE or ES_SAVESEL or ES_AUTOVSCROLL or ES_READONLY;
  end;
{    Style := Style or HideScrollBars[FHideScrollBars] or
      HideSelections[HideSelection];}
end;

procedure TMyRichEdit.WMNCDestroy(var Message: TWMNCDestroy);
begin
  inherited;
  if FLibHandle <> 0 then FreeLibrary(FLibHandle);
end;

function TMyRichEdit.GetLines : Integer;
begin
     GetLines := SendMessage (Handle,EM_GETLINECOUNT,0,0);
end;

function TMyRichEdit.GetFirstLine : Integer;
begin
     GetFirstLine := SendMessage (Handle,EM_GETFIRSTVISIBLELINE,0,0);
end;

procedure TMyRichEdit.SetFirstLine (iPos : Integer);
begin
   SendMessage (Handle,EM_LineScroll,0,iPos - GetFirstLine);
end;

procedure Register;
begin
  RegisterComponents('Win95', [TMyRichEdit]);
end;

end.
