unit UStatistik;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls,UConvertData,Math;

procedure CharStatOutput (var oData: SRConvertData);

implementation

type

 TCharStatData = class
 public
    cValue : char;
    iCount : integer;
 end;

function CompareCharacter(Item1, Item2: Pointer): Integer;
begin
     if TCharStatData(Item1).iCount = TCharStatData(Item2).iCount then
        CompareCharacter := 0
     else if TCharStatData(Item1).iCount < TCharStatData(Item2).iCount then
        CompareCharacter := 1
     else
        CompareCharacter := -1;
end;

// Ausgabe der Zeichen- Statistik
procedure CharStatOutput (var oData: SRConvertData);
var oList : TList;
    oRec : TCharStatData;
    iMem : Integer;
    i : Integer;
    iBits,iBytes : Integer;

begin

  // Elemente der Gre nach sortieren:

  // dazu ein TList Objekt aufbauen:
  oList := TList.Create;
  for i := 0 to 255 do
  begin
     if (oData.iaCharStat[i] <> 0) and (i <> ord('$'))then // Verhindern, da ergebnis von Steuerzeichen verflscht wird.
     begin
       // Datenobjekt erzeugen
       oRec := TCharStatData.Create;
       oRec.cValue := chr (i);
       oRec.iCount := oData.iaCharStat[i];
       // und dem Array hinzufgen
       oList.Add (oRec);
     end;
  end;

  // und sortieren lassen:
  oList.Sort (CompareCharacter);

  // Ausgabe:
  iMem := 0;
  oData.Log.Lines.Add ('');
  oData.Log.Lines.Add ('Zeichenstatistik:');
  oData.Log.Lines.Add ('Es wurden ' + IntToStr (oList.Count) + ' Zeichen verwendet:');

  // Anzahl der Balken angeben:
  oData.CharStat.NumPoints := oList.Count;

  for i := 0 to oList.Count-1 do
  begin
    // Ausgabe:
{    oData.Log.Lines.Add ('Zeichen "'+ TCharStatData (oList [i]).cValue +
                        '",'+ IntToStr (ord (TCharStatData (oList [i]).cValue))+' wurde'+
                        IntToStr(TCharStatData(oList [i]).iCount) +
                        ' verwendet.'); }
    // Gleichzeitig die Gesamtlnge bei Entropiekodierung ermitteln:
    iMem := iMem + TCharStatData(oList [i]).iCount * (i+1);

   // Grafische Darstellung der Statistik erzeugen:
   oData.CharStat.ThisPoint := i+1;
   oData.CharStat.LabelText := TCharStatData (oList [i]).cValue;
   oData.CharStat.GraphData := TCharStatData(oList [i]).iCount;


  end;

  // Chart Darstellen
  oData.CharStat.DrawMode := 2;

  oData.Log.Lines.Add ('Gesamtzahl der Zeichen: '+ IntToStr(oData.iCharCount));
  oData.Log.Lines.Add ('Entropie- Kodierung: '+ IntToStr((iMem div 8) +1) + ' Zeichen (' +
                      FloatToStrF(iMem / (8 * oData.iCharCount) * 100,ffGeneral,7,2)
                      +'%).');

  iBits := Trunc(log2 (oList.Count) +1);
  iBytes := iBits * oData.iCharCount div 8;
  oData.Log.Lines.Add ('Zur Darstellung sind ' + IntToStr (iBits) +
                      ' Bits ntig, dadurch ergibt sich eine Gesamtnge von ' + IntToStr (iBytes) +
                      ' Zeichen (' + FloatToStrF(iBytes / oData.iCharCount * 100,ffGeneral,7,2) +
                      '%).');
  oData.Log.Lines.Add ('');





end;

end.
