unit UConvertVers;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls,UConvertData,UConvertWord,UStatistik;

function ConvertVers (var oData : SRConvertData) : TStringList;

implementation

function ConvertVers (var oData : SRConvertData) : TStringList;
var stWord : string;
    iLast,i,iIndex : Integer;
    oWordList : TStringList;
    blBreak : Boolean;
    blFound : Boolean;
    oWordData : TWordStatData;
    stBook : string;
begin
   oWordList := TStringList.Create;
   oWordList.Sorted := FALSE; // keine Sortierung

   try
      blBreak := FALSE;


      while blBreak = FALSE do
      begin

         oData.blNewLine := FALSE;
         // Worte einer Zeile in die Wortliste einfgen
         oWordList.Clear;
         if oData.stLastWord <> '' then begin// Ist aus der letzten Verarbeitung ein Wort brig?
            oWordList.Add (oData.stLastWord); // mit diesem Wort beginnen:
            oData.stLastWord := '';
         end;

         while oData.blNewLine = FALSE do
         begin
            stWord := WordConvert (oData);

            // nur Einfgen, wenn nicht das erste Zeichen einer Zeile:
            if oData.blNewLine = FALSE then
               oWordList.Add (stWord);
         end;

         iLast := oWordList.Count -1;
         oData.blNewLine := FALSE; // Schalter zurcksetzen:
         // Extrawurst fr die 1. Reihe!
         if oData.blFirstLine = TRUE then
         begin
            // Versname und Buch ermitteln
            oData.iNextChapter := StrToInt (stWord);
//            oData.stBook := oWordList[iLast];
            oData.stNextBook := '1. Mose';
            // Nchstes Wort ist die Versnummer:
            oData.iNextVers := StrToInt (WordConvert(oData));

            // Statistik:
            Inc (oData.oStat.iChapterCount);
            Inc (oData.oStat.iBookCount);

            oData.blFirstLine := FALSE;

         end else begin
            // Regulre Verarbeitung
            blBreak := TRUE;

            oData.iVers := oData.iNextVers;
            oData.iChapter := oData.iNextChapter;
            oData.stBook := oData.stNextBook;
            oData.stPart := oData.stNextPart;

            oData.iNextVers := StrToInt (WordConvert(oData));
            // Neue Chapter?
            if oData.iNextVers = 1 then
            begin
               // Wieder ein neues Kapitel
               inc (oData.oStat.iChapterCount);

{Abbruch}      //oData.blBreak := TRUE;
               oData.iChapter := oData.iNextChapter;
               oData.iNextChapter := StrToInt (stWord);


               stBook := oWordList[iLast];

               if stBook <> oData.stLastBook then
               begin

                  oData.stLastBook := stBook;
                  if stBook = 'Matthus' then
                    oData.stNextPart := cstNT;
                  inc (oData.oStat.iBookCount);

                  if stBook = 'Psalter' then stBook := 'Psalm';
                  if stBook = 'Apostelgeschich' then stBook := 'Apostelgeschiche';
                  // Bchername aufbereiten:
                  if stBook[1] in ['1','2','3','4','5','6','7','8','9'] then
                  begin
                      oData.stNextBook := stBook [1] + '. ' + UpperCase (stBook[2]) + Copy (stBook,3,Length(stBook));
                  end else begin
                      oData.stNextBook := UpperCase (stBook[1]) + Copy (stBook,2,Length(stBook));
                  end;

                 // Positionsausgabe
                 oData.log.lines.Add (oData.stNextPart+':'+ oData.stNextBook);

               end;

               // Das letzte Wort dient nur der Verszhlung, also terminieren:
               oWordList.Delete (iLast);


            end else begin
               // Wenn kein neues Kapitel beginnt, ist in stWord dass letzte Wort des letzten Satzes
               // also mit in Array aufnehmen:
               oWordList.Add (stWord);
            end;
         end;

         // evt. der Nummer folgenden Punkt terminieren:
         stWord := WordConvert (oData);
         if stWord <> '.' then
            oData.stLastWord := stWord
      end;


      // Vers der Wortstatistik hinzufgen:

      // ber alle Wrter des Verses iterieren:
      for iIndex := 0 to oWordList.Count -1 do
      begin
         // Wortzhler:
         inc (oData.oStat.iWordCount);
         blFound := FALSE;

         // Suchen, ob Wort bereits erfat:
         for i := 0 to oData.oWordStat.Count -1 do
         begin
            if TWordStatData(oData.oWordStat[i]).stWord = oWordList [iIndex] then
            begin  // gefunden !!
               // Zhler erhhen
               TWordStatData(oData.oWordStat[i]).iCount := TWordStatData(oData.oWordStat[i]).iCount +1;

               blFound := TRUE;
               Break; // Suche beednen
            end;
         end;

         if blFound = FALSE then // Wurde nicht gefunden:
         begin // neuen Datensatz erzeugen:
            oWordData := TWordStatData.Create;
            oWordData.stWord := oWordList [iIndex];
            oWordData.iCount := 1;
            oData.oWordStat.Add (oWordData);

            // Alle 100 Einttrge Worttatistik sorieren, um Treffergeschwindigkeit zu erhhen
            if (oData.oWordStat.Count mod 100) = 1 then
            begin
              // Wortstatistik sortieren:
              oData.oWordStat.Sort (CompareWords);
            end;


         end;
      end;
   except
      // Wenn keine Daten hier vorhanden, Exception weiterleiten:
      if oWordList.Count = 0 then raise;
   end;

   // VersZhler hochzhlen:
   inc (oData.oStat.iVersCount);

   // Daten zurckgeben:
   ConvertVers := oWordList;

end;


end.
