unit UConvertWord;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls,UConvertData,UConvertStream;


function WordConvert (var oData : SRConvertData): string;


implementation

function WordConvert (var oData : SRConvertData): string;
const LineLength = 200;
var stWord : string;
    cChar : char;
    icSpaceList : set of char;
begin

  icSpaceList := [' ',',','.',':',';','?','!'];
  // Erkanntes Wort zuerst lschen:
  if oData.stLastChar = chr (0) then // ist ein zurckgelegtes Byte vorhanden, dann verarbeiten!
  begin
    stWord := '';
  end else begin
    stWord := oData.stLastChar;
    oData.stLastChar := chr (0);
  end;

  // Damit Satzzeichen als einzelne Wrter erfat werden knnnen,
  // mssen Sie hier bereits abgefangen werden:
  if (Length (stWord) < 1) or not (stWord [1] in icSpaceList) then
  begin

     try
        repeat
          // Zeichen des Wortes erkennen
          cChar := GetNextCharacter (oData);

          // Statistik updaten:
          inc (oData.iaCharStat [ord(cChar)]);
          inc (oData.iCharCount);

          if not (cChar in icSpaceList) then            // Wenn Buchstabe keine Space, dann zum
             stWord := stWord + cChar;    // Wort hinzufgen
        until  (cChar in icSpaceList);

        // alle Zeichen auer Space in der nchsten Runde weiterverarbeiten:
        if cChar <> ' ' then
           oData.stLastChar := cChar

    except
       // evt. vorhandene Daten zurckliefern
       if Length (stWord) = 0 then raise; // keine Daten, also wieder auslsen

    end;
 end else begin
   // evt. Leerzeichen hinter dem Satzzeichen elmenieren:
   cChar := GetNextCharacter (oData);
   if cChar <> ' ' then // Wenn e kein Space ist,
      oData.stLastChar := cChar; // Dann zurcklegen:

 end;

 // Wort zurckliefern:
 WordConvert := stWord;

end;


end.
