unit UCreateBible;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls,UConvertData;

procedure CreateBibleFile (var oData : SRCreateData);

implementation

// Strings aus dem Stream lesen
procedure ReadStringsFromStream (var strFile : TStream;var oVers : TStringList);
var i,count,j : Integer;
    szBuf : array [0..MAX_PATH] of char;
begin
     oVers.Clear;
     strFile.Read (count,4); // ANzahl der Strings lesen

     for i := 1 to count do
     begin
        strFile.Read (j,4); // Lnge des Stings lesen
        strFile.Read (szBuf,j);
        oVers.Add (szBuf);
     end;

end;



procedure WriteStringList (iFile : Integer;oList : TStringList);
var iIndex,iCount,iBufLen,iBufIndex : Integer;
    pBuffer : pchar;
begin
   // zuerst emitteln, wie gro der Buffer sein mu:
   iCount := oList.Count;
   iBufLen := 0;

   for iIndex := 0 to iCount-1 do
       inc (iBufLen,Length(oList[iIndex])+1);

   // Buffer allokieren:
   pBuffer := pChar (GlobalAlloc (GPTR,iBufLen));

   if pBuffer = Nil then
      raise EOutOfMemory.Create ('Bibel Synthese: WriteStringList');


   // Alle Strings in den Buffer schreiben:
   iBufIndex := 0;
   for iIndex := 0 to iCOunt-1 do
   begin
        strpcopy (@pBuffer[iBufIndex],oList[iIndex]);
        inc(iBufIndex,Length(oList[iIndex])+1);
   end;

   // Datei in Datei speichern:

   FileWrite (iFile,iCount,4); // Zuerst die Wortanzahl
   FileWrite (iFile,iBufLen,4); // Dann die Textlnge
   FileWrite (iFile,pBuffer^,iBufLen); // Nun den Buffer


   // Speicher wieder freigeben
   GlobalFree (HGLOBAL (pBuffer));

end;


procedure CreateBibleFile (var oData : SRCreateData);
var strFile : TStream;
    oVers,oWords : TStringList;
    oBooks,oParts : TStringList;
    stLastBook,stBook,stPart,stLastPart : string;
    oStat : SRStat;
    i,iIndex : integer;
    piWordList : pchar;
    piVersList,piChapterList,piBookList : pchar;
    iChapter,iLastChapter : Integer;
    iWordIndex,iVersIndex,iChapterIndex,iBookIndex : Integer; // Indizes fr Zeigerzugriffe
    iAT,iNT : Word;
    iFile : Integer;
    iLastWordIndex,iLastVersIndex,iLastChapterIndex : Integer;
    c : char;
begin

   // 1. Stream ffnen
   // enthlt Wortliste und Parameterliste
   strFile := TFileStream.Create (cstTempFileName2,fmOpenRead);

   // Statistik-Daten einlesem
   strFile.Read (oStat,SizeOf (oStat));
   oData.log.lines.add ('');
   oData.log.lines.add ('Synthese:');
   oData.log.lines.add ('');
   oData.log.lines.add ('Wrter: ' + IntToStr (oStat.iWordCount));
   oData.log.lines.add ('Verse: ' + IntToStr (oStat.iVersCount));
   oData.log.lines.add ('Kapitel: ' + IntToStr (oStat.iChapterCount));
   oData.log.lines.add ('Bcher: ' + IntToStr (oStat.iBookCount));

   // Wortliste einlesen:
   oWords := TStringList.Create;
   oBooks := TStringList.Create;
   oParts := TStringList.Create;
   oWords.LoadFromStream (strFile);

   oData.log.lines.add ('Lnge der Wortliste:' + IntToStr (oWords.Count));

   // File2 schlieen :
   strFile.Free;

   // Speicher fr Bibel-Listen erzeugen:
   piWordList := Pchar(GlobalAlloc (GPTR,oStat.iWordCount*2));
   piVersList := Pchar(GlobalAlloc (GPTR,oStat.iVersCount));
   piChapterList := Pchar(GlobalAlloc (GPTR,oStat.iChapterCount));
   piBookList := Pchar(GlobalAlloc (GPTR,oStat.iBookCount));

   if (piWordList = Nil) or (piVersList = Nil) or
      (piChapterList = Nil) or (piBookList = Nil) then
         raise EOutOfMemory.Create ('Bibel Synthese');

   // und File1 ffnen:
   strFile := TFileStream.Create (cstTempFileName1,fmOpenRead);

   oVers := TStringList.Create;

   iWordIndex := 0;
   iChapterIndex := 0;
   iBookIndex := 0;
   iLastChapter := 0;
   stLastBook := '';
   iAT := 0;
   iNT := 0;

   iLastWordIndex := 0;
   iLastVersIndex := 0;
   iLastChapterIndex := 0;

   // ber alle Verse iterieren
   for iVersIndex := 0 to oStat.iVersCount-1 do
//   for iVersIndex := 0 to 20 do
   begin
      // Vers fr Vers laden und verarbeiten:
      ReadStringsFromStream (strFile,oVers);

      // Versnummerierung identifizieren und entfernen:
//      iVers    := StrToInt (oVers[oVers.Count-4]);
      iChapter := StrToInt (oVers[oVers.Count-3]);
      stBook := oVers[oVers.Count-2];
      stPart := oVers[oVers.Count-1];


      oVers.Delete(oVers.Count-1);
      oVers.Delete(oVers.Count-1);
      oVers.Delete(oVers.Count-1);
      oVers.Delete(oVers.Count-1);

      // Gliederungslisten updaten:

      // Versliste:

//      piVersList [iVersIndex] := iWordIndex;
{      oData.log.lines.Add (stBook + ' '+IntToStr (iChapter)+' ' + INtToStr (iVersIndex) +
                          'AkI: '+ IntToStr (iWordIndex) +'Last:'+IntToSTr (iLastWordIndex)); }
      piVersList [iVersIndex] := char(INteger(iWordIndex - iLastWordIndex) and 255);
      iLastWordIndex := iWordIndex;

      // Kapitelliste
      if iLastChapter <> iChapter then
      begin
         iLastChapter := iChapter;


//         piChapterList [iChapterIndex] := iVersIndex; // Index bernehmen:
         piChapterList [iChapterIndex] := char(Integer(iVersIndex - iLastVersIndex) and 255); // Index bernehmen:
         iLastVersIndex := iVersIndex;

         // Buckliste
         if stLastBook <> stBook then
         begin
            stLastBook := stBook;
            oBooks.Add (stBook); // Buchaname zur BUchnamenliste hinzufgen
//            piBookList [iBookIndex] := iChapterIndex;
            piBookList [iBookIndex] := char(Integer(iChapterIndex - iLastChapterIndex) and 255);
            iLastChapterIndex := iChapterIndex;

            if stLastPart <> stPart then begin
               oParts.Add (stPart); // Abschnittsname zur Abschnittsnamensliste hihnzu
               stLastPart := stPart;
               iNT := iBookIndex;
            end;

            inc (iBookIndex);
            oData.log.lines.add (stPart+':'+stBook);
         end;
         inc (iChapterIndex);
      end;

      // Wrter des Verses in Indizes auf die Wortliste konvertieren:
      for iIndex := 0 to oVers.Count -1 do // ber alle Wrter iterieren:
      begin
         // Fr jedes Wort den Index ermitteln:
         for i := 0 to oWords.Count do
         begin
            if oWords[i] = oVers[iIndex] then // Wenn gefunden:
               BreaK; // Abbruch
         end;

         // Index speichern

         i := i shl 1; // Wert verschieben
         if i <= 254 then // Gehrt Wert zu den untersten 127 ?
         begin
           piWordList [iWordIndex] := char (i and 255);
           inc (iWordIndex); // Zhler auf nchstes Wort setzen
         end else begin
           i := i or 1;
           piWordList [iWordIndex] := char (i and 255);
           inc (iWordIndex); // Zhler auf nchstes Wort setzen
           i := i shr 8; // Hherwertigen Bereich ermitteln:
           piWordList [iWordIndex] := char (i and 255);
           inc (iWordIndex); // Zhler auf nchstes Wort setzen
         end;

      end;


{      for i := 0 to oVers.Count -1 do
          stTemp := stTemp + ' ' +oVers[i];

      oData.log.lines.add (stTemp);}


   end;


   // Daten speichern:

   // 1. Name.Copyright
   oVers.Clear;
   oVers.Add (cstName);
   overs.Add (cstCopyright);

   // Ausgabedatei ffnen:
   iFile := FileCreate (cstFileName);

   // Copyright schreiben
   WriteStringList (iFile,oVers);

   // Wortliste schreiben
   WriteStringList (iFile,oWords);

   // Versliste schreiben:
   FileWrite (iFile,iVersIndex,4);
   FileWrite (iFile,piVersList^,iVersIndex);

   // Kapitelliste schreiben:
   FileWrite (iFile,iChapterIndex,4);
   FileWrite (iFile,piChapterList^,iChapterIndex);

   // Buchliste schreiben:
   WriteStringList (iFile,oBooks);
   FileWrite (iFile,piBookList^,iBookIndex);


   // Abschnitteliste schreiben:
   WriteStringList (iFile,oParts);
   c := chr (iAT and 255);
   FileWrite (iFile,c,1);
   c := chr (iNT and 255);
   FileWrite (iFile,c,1);

   // Wortliste
   oData.log.lines.Add ('Lnge Text:'+ IntToStr (iWordIndex));
   FileWrite (iFile,piWordList^,iWordIndex);

   
   //Datei schlieen
   FileClose (iFile);

   // Aufrumen:
   GlobalFree (HGLOBAL(piWordList));
   GlobalFree (HGLOBAL(piVersList));
   GlobalFree (HGLOBAL(piChapterList));
   GlobalFree (HGLOBAL(piBookList));
   strFile.Free;
   oVers.Free;
   oWords.Free;
   oBooks.Free;
   oParts.Free;


end;

end.
