unit UStatistik;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls,UConvertData,Math;

procedure CharStatOutput (var oData: SRConvertData);
procedure WordStatOutput (var oData : SRConvertData);
function CompareWords(Item1, Item2: Pointer): Integer;

implementation

type

 TCharStatData = class
 public
    cValue : char;
    iCount : integer;
 end;

function CompareCharacter(Item1, Item2: Pointer): Integer;
begin
     if TCharStatData(Item1).iCount = TCharStatData(Item2).iCount then
        CompareCharacter := 0
     else if TCharStatData(Item1).iCount < TCharStatData(Item2).iCount then
        CompareCharacter := 1
     else
        CompareCharacter := -1;
end;

// Ausgabe der Zeichen- Statistik
procedure CharStatOutput (var oData: SRConvertData);
var oList : TList;
    oRec : TCharStatData;
    iMem : Integer;
    i : Integer;
    iBits,iBytes : Integer;

begin

  // Elemente der Gre nach sortieren:

  // dazu ein TList Objekt aufbauen:
  oList := TList.Create;
  for i := 0 to 255 do
  begin
     if (oData.iaCharStat[i] <> 0) and (i <> ord('$'))then // Verhindern, da ergebnis von Steuerzeichen verflscht wird.
     begin
       // Datenobjekt erzeugen
       oRec := TCharStatData.Create;
       oRec.cValue := chr (i);
       oRec.iCount := oData.iaCharStat[i];
       // und dem Array hinzufgen
       oList.Add (oRec);
     end;
  end;

  // und sortieren lassen:
  oList.Sort (CompareCharacter);

  // Ausgabe:
  iMem := 0;
  oData.Log.Lines.Add ('');
  oData.Log.Lines.Add ('Zeichenstatistik:');
  oData.Log.Lines.Add ('Es wurden ' + IntToStr (oList.Count) + ' Zeichen verwendet:');

  // Anzahl der Balken angeben:
//  oData.CharStat.NumPoints := oList.Count;

  for i := 0 to oList.Count-1 do
  begin
    // Ausgabe:
{    oData.Log.Lines.Add ('Zeichen "'+ TCharStatData (oList [i]).cValue +
                        '",'+ IntToStr (ord (TCharStatData (oList [i]).cValue))+' wurde'+
                        IntToStr(TCharStatData(oList [i]).iCount) +
                        ' verwendet.'); }
    // Gleichzeitig die Gesamtlnge bei Entropiekodierung ermitteln:
    iMem := iMem + TCharStatData(oList [i]).iCount * (i+1);

   // Grafische Darstellung der Statistik erzeugen:
   oData.CharStat.lines.Add ('"'+ TCharStatData (oList [i]).cValue +'": '
                            + IntToStr (TCharStatData(oList [i]).iCount) +
                            ' mal.');
{   oData.CharStat.ThisPoint := i+1;
   oData.CharStat.LabelText := TCharStatData (oList [i]).cValue;
   oData.CharStat.GraphData := TCharStatData(oList [i]).iCount;
}

  end;

  // Chart Darstellen
//  oData.CharStat.DrawMode := 2;

  oData.Log.Lines.Add ('Gesamtzahl der Zeichen: '+ IntToStr(oData.iCharCount));
  oData.Log.Lines.Add ('Entropie- Kodierung: '+ IntToStr((iMem div 8) +1) + ' Zeichen (' +
                      FloatToStrF(iMem / (8 * oData.iCharCount) * 100,ffGeneral,7,2)
                      +'%).');

  iBits := Trunc(log2 (oList.Count) +1);
  iBytes := iBits * oData.iCharCount div 8;
  oData.Log.Lines.Add ('Zur Darstellung sind ' + IntToStr (iBits) +
                      ' Bits ntig, dadurch ergibt sich eine Gesamtnge von ' + IntToStr (iBytes) +
                      ' Zeichen (' + FloatToStrF(iBytes / oData.iCharCount * 100,ffGeneral,7,2) +
                      '%).');
  oData.Log.Lines.Add ('');


  // Speicher fr sortiertes Array freigeben:
  for i := 0 to oList.Count -1  do
      TCharStatData(oList [i]).Free;
  oList.Free;

  // Vers- Kapitel-Book-Statisik ausgeben:
  oData.Log.Lines.Add ('Versanzahl: '+ IntToStr (oData.oStat.iVersCount));
  oData.Log.Lines.Add ('Kapitelanzahl: '+ INtToStr (oData.oStat.iChapterCount));
  oData.Log.Lines.Add ('Buchanzahl: '+IntToStr (oData.oStat.iBookCount));



end;

function CompareWords(Item1, Item2: Pointer): Integer;
begin
     if TWordStatData(Item1).iCount = TWordStatData(Item2).iCount then
        CompareWords := 0
     else if TWordStatData(Item1).iCount < TWordStatData(Item2).iCount then
        CompareWords := 1
     else
        CompareWords := -1;
end;

procedure WordStatOutput (var oData : SRConvertData);
var i : Integer;
    iMem : Integer;
    iMem127 : Integer;
    iWordMem : Integer;
    iVersTab,iChapterTab,iBookTab : Integer;
    iSumMem : Integer;
    iSumBits,iVersBits,iChapterBits{,iBookBits} : Integer;
begin

     // Wortstatistik sortieren:
     oData.oWordStat.Sort (CompareWords);

     // Ausgabe der Gesamtwortzahl
     oData.WordStat.Lines.Add ('Es sind insgesammt '
                              + IntToStr (oData.oStat.iWordCount) + ' Wrter.');
     oData.WordStat.Lines.Add ('und ' + IntToStr (oData.oWordStat.Count) +' verschiedene Wrter');
     oData.WordStat.Lines.Add ('Die 127 hufigsten Wrter:');

     // Die 127 hufigsten Wrter:
     iMem127 := 0;
     iWordMem := 0;
     for i := 0 to 126 do
     begin
        oData.WordStat.Lines.Add ('"' +TWordStatData(oData.oWordStat[i]).stWord + '" ' +
                                IntToStr (TWordStatData(oData.oWordStat[i]).iCount) +
                                ' mal.');
        // Speicherbedarf berechnen:
        iMem127 := iMem127 + TWordStatData(oData.oWordStat[i]).iCount;
        iWordMem := IWordMem + Length (TWordStatData(oData.oWordStat[i]).stWord) +1;// Nummterminiert: +1
     end;

     // alle Restlichen Wrter fr Tabelle erfassen:
     for i := 127 to oData.oWordStat.Count -1 do
     begin
        iWordMem := iWordMem + Length (TWordStatData(oData.oWordStat[i]).stWord) +1;// Nummterminiert: +1
     end;

     // Wortliste mit 7Bit speichern:
     iWordMem := trunc (iWordMem / 8 * 7);

     // Speicherbedarf fr Wort-Indizes
     iMem :=  (oData.oStat.iWordCount -iMem127) * 2;

     // Speicherbedarf fr Gliederungslisten:
     iVersBits := Round (log2 (oData.oStat.iVersCount) + 0.49);
     iChapterBits := Round (log2 (oData.oStat.iChapterCount)+ 0.49);
//     iBookBits := Round (log2 (oData.iBookCount)+ 0.49);
     iSumBits := Round (log2 (iMem+iMem127) + 0.49);

     iVersTab := Round((((oData.oStat.iVersCount +1) * iSumBits) / 8)+ 0.49);
     iChapterTab := Round((((oData.oStat.iChapterCount +1) * iVersBits) /8)+ 0.49);
     iBookTab := Round((((oData.oStat.iBookCount +1) * iChapterBits) /8)+ 0.49);

     // Gesamtspeicherbedarf ermitteln:
     iSumMem := iMem127 + iMem + iWordMem + iVersTab + iChapterTab + iBookTab;

     // fr Speicher auch die Taellen hinzufgen:

     oData.WordStat.Lines.Add ('Gesamte Speicherungsgre: ' + IntToStr (iSumMem) + ' (' +
                      FloatToStrF(iSumMem / oData.iCharCount * 100,ffGeneral,7,2)
                      +'%).');
     oData.WordStat.Lines.Add ('Die 127 hufigsten Wrter kommen insgesammt '+ INtToStr (iMem127)+' mal vor.');

    // Einzelpostenauflistung:
     oData.WordStat.Lines.Add ('Word-Indizes-Liste: '+IntToSTr (oData.oStat.iWordCount) +
                              ' Wrter = '+ IntToStr (iMem+iMem127) + ' Bytes.');
     oData.WordStat.Lines.Add ('Wortliste: '+IntTostr (oData.oWordStat.Count)+
                              ' verschiedene Wrter = ' + IntToStr (iWordMem) + ' Bytes.');
     oData.WordStat.Lines.Add ('Verliste: '+ IntToStr (oData.oStat.iVersCount) +
                              ' Verse, Speicherung mit ' + IntToStr (iSumBits) +
                              ' Bits = ' + IntToStr (iVersTab) +' Bytes.');
     oData.WordStat.Lines.Add ('Kapitelliste: '+ IntToStr (oData.oStat.iChapterCount) +
                              ' Kapitel, Speicherung mit ' + IntToStr (iVersBits) +
                              ' Bits = ' + IntToStr (iChapterTab) +' Bytes.');
     oData.WordStat.Lines.Add ('Buchliste: '+ IntToStr (oData.oStat.iBookCount) +
                              ' Bcher, Speicherung mit ' + IntToStr (iChapterBits) +
                              ' Bits = ' + IntToStr (iBookTab) +' Bytes.');


end;

end.
