unit UConvertStream;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls,UConvertASCII,UConvertData;


function GetNextCharacter (var oData : SRConvertData): char;


implementation




function ASCIIConvert (cData : char) : char;
begin

   case Integer(cData) of
      $84      : ASCIIConvert := '';
      $94      : ASCIIConvert := '';
      $81      : ASCIIConvert := '';
      $8e      : ASCIIConvert := '';
      $99      : ASCIIConvert := '';
      $9a      : ASCIIConvert := '';
      $e1      : ASCIIConvert := '';
//      ord('}') : ASCIIConvert := '';
      ord(''''): ASCIIConvert := '"';
      ord('') : ASCIIConvert := '"';
      ord('`') : ASCIIConvert := '"';
      ord ('~'): ASCIIConvert := '-';
      else       ASCIIConvert := cData;
   end;

end;

function GetCharacter (var oData : SRConvertData): char;
var cChar : char;
begin
   if oData.blBreak = TRUE then
      raise Exception.Create ('Ready');

   if oData.inStream <> Nil then
   begin
      // Knnen aus dem aktuellen Stream noch Daten gelesen werden?
      if (oData.inStream.Size - oData.inStream.Position) = 0 then
      begin
         with oData do
         begin
            inStream.Free;
            inStream := Nil;
            iFileNr := iFileNr +1;

 //           if iFileNr > cFileCount then
            if iFileNr > 1 then
            begin
              oData.blBreak := TRUE;
              raise Exception.Create ('Ready');
            end;

         end;
      end;
   end;

   // Stream erzeugen,
   if oData.inStream = NIL then
   begin
     oData.inStream := TFileStream.Create (ExtractFileDir (Application.EXEName) +
            cstSourceFile,fmOpenRead + fmShareDenyNone);


   end;
   oData.inStream.Read (cChar,1);
   // Neue Zeile erkennen:
   if (cChar = chr (10)) or (cChar = chr (13)) then
      oData.blNewLine := TRUE;

   GetCharacter := ASCIIConvert (cChar);

end;

// Zeilenumbrche, doppelte Abstzschaltung, doppelte Spaces
// herausfiltern:
function GetNextCharacter (var oData : SRConvertData): char;
var cChar : char;
    cSpaces : set of char;
begin
   // Rckgabedatum lschen:
   cChar := chr(0);

   try
      // Ergebnis lschen
 //     cSpaces := [chr (9),chr(10),chr(13),' '];
      cSpaces := [chr (0)..chr (32)];
//      cControlChars := [chr (0)..chr(31),chr (127)..chr (255)];

      // Zeichen ermitteln:
      if oData.cPutBack <> chr(0) then
      begin
         cChar := oData.cPutBack;
         oData.cPutBack := chr(0);
      end else begin
         cChar := GetCharacter (oData);

      end;

      // Filtern:
      if cChar in cSpaces then
      begin
        // alle weiteren chr (10),chr (13),' ' werden berlesen:
        while cChar in cSpaces do
           cChar := GetCharacter (oData);

        // 1. gltiges Elemet fr nchsten Aufruf zurckschreiben:
        oData.cPutBack := cChar;

        cChar := ' ';
      end;
   except
      // Wurde eine Exception ausgelst, vorhandenen Datem zurckgeben:
      if cChar in cSpaces   then raise; // keine Daten vorhanden, Exception weiterleiten
   end;

   // ansonsten Char weitergeben:
   GetNextCharacter := cChar;

end;


end.

