// ***************************************
//       Die Bibel fr Windows 3.1 & 95
// ***************************************
//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************
//   Bibeltext- Small-Viewer
// ***************************************
//   About- Dialog
// ***************************************
//   about.cpp
// ***************************************
#include <bibel.h>

BOOL CALLBACK AboutDialogProc(
	 HWND  hWnd,	// handle of dialog box
	 UINT  uMsg,	// message
	 WPARAM  wParam,	// first message parameter
	 LPARAM  //lParam 	// second message parameter
	)
{
	switch (uMsg)
	{
		case WM_INITDIALOG :
		{
			int i,iCount = glpBibelList -> count ();
			char far * c = (char far*) farmalloc (iCount * 256);

			if (!c)
			{
				SendDlgItemMessage (hWnd,DLG_1,WM_SETTEXT,0,
					(long)"Nicht gengend Speicher zur Anzeige der Textrechte");
				return 1;
			}

			c[0] = '\0';
			TBibelTextData *pData;

			for (i=0;i< iCount;i++)
			{
				pData = (TBibelTextData*)glpBibelList -> data (i);
				_fstrcat (c,pData -> name ());

				_fstrcat (c,"\r\n");

				_fstrcat (c,pData -> copyright ());
				_fstrcat (c,"\r\n\r\n");
			}

			SendDlgItemMessage (hWnd,DLG_1,WM_SETTEXT,0,(long)c);

			farfree (c);

			return 1;
		}
		case WM_COMMAND :
			switch (LOWORD(wParam))
			{
				case IDOK :
					EndDialog (hWnd,TRUE);
					return 1;
				case IDHELP :
					MessageBox (hWnd,"Comes later...","Help",MB_OK);
					return 1;
			}
			break;

   }

	return 0;
}

void about_dialog (HWND hParent)
{

#ifndef __WIN32__
	FARPROC fpProc = MakeProcInstance ((FARPROC)AboutDialogProc,glhInstance);
#else
	FARPROC fpProc =(FARPROC)AboutDialogProc;
#endif


	DialogBox (glhInstance,MAKEINTRESOURCE (About_DLG),hParent,(DLGPROC)fpProc);

#ifndef __WIN32__
	FreeProcInstance (fpProc);
#endif
}

