// ***************************************
//       Die Bibel fr Windows 3.1 & 95
// ***************************************
//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************
//   Header-Datei fr 16- & 32Bit-Version
// ***************************************
//   Bibelist.H
// ***************************************
#include "bibdll.h"


#include "navigat.h"
#include "bibtext.h"

#ifdef __DLL__
	#define _BIBLIST_IMPEX FAR _export
#endif

#include "bibelist.h"



// load basis infos about all avaliable Bibels
TBibelList::TBibelList (HINSTANCE hInstance)
{
	char szModulePath [MAX_PATH];


	// set all vars to NULL
	m_pData = NULL;
	m_uCount = NULL;
	int i;

	// Modul-Pfad ermitteln:
	GetModuleFileName (hInstance,szModulePath,MAX_PATH);

	// das letzte Backslash suchen:
	for (i=strlen (szModulePath);i > 0 && szModulePath[i] != '\\';i--)
		;
	if (i > 0)
		szModulePath [i+1] = '\0';

	// first load bibles in the actual path
	search_in_path (szModulePath);
}


void TBibelList::search_in_path (const char *cszPath)
{
	char bfBuf [MAX_PATH],szFile [MAX_PATH];
	ffblk ffb;

	int u;

	strcpy (bfBuf,cszPath);
	strcat (bfBuf,"*.bib"); // Suchstring erzeugen

	// Anzahl der Bibeln im Verzeichnis ermitteln:
	int iFound = findfirst (bfBuf,&ffb,0);

	while (iFound == 0) {

		strcpy (szFile,cszPath);
		strcat (szFile,ffb.ff_name);

		// create bibel object:
		TBibelTextData *pBibel = new TBibelTextData (szFile,ffb.ff_fsize);

		if (!pBibel)
			EXCEPT ("Cant load bible in search_in_path()",);

		if (m_uCount && m_pData)
		{
			for (u=0;u < m_uCount;u++)
			{
				if (strcmp (m_pData[u] -> name (),pBibel -> name ()) == 0)
				{
					delete pBibel;
					pBibel = 0;
					break;
				}
			}
		}

		if (pBibel)
		{
			m_uCount++;

			// Allocate Memory for the new bibel:
			TBibelTextData **pTempArr =
				new TBibelTextData*[m_uCount];

			// if an array allready exists, copy it
			if (m_pData)
			{
				memcpy (pTempArr,m_pData,(m_uCount-1)* sizeof (TBibelTextData*));
				delete [] m_pData;
			}

			m_pData = pTempArr;

				// Dateiname erzeugen:
			strcpy (szFile,cszPath);
			strcat (szFile,ffb.ff_name);

			m_pData [m_uCount-1] = pBibel;

		}

		iFound = findnext (&ffb);
	}

}

TBibelList::~TBibelList ()
{
	int i;
	for (i=0;i<m_uCount;i++)
	{
		if (m_pData && m_pData[i])
			delete m_pData [i];
	}
	if (m_pData)
		delete []m_pData;
}


IBibelTextData* _DLLCALL TBibelList::data (unsigned uIndex) const
{
	if (uIndex > m_uCount)
	{

#ifdef _EXCEPT_
		char szBuf [200];
		sprintf (szBuf,"Index zu gro: %i, (gltig:0-%i) in data()",
			uIndex-1,m_uCount);
#endif
		EXCEPT (szBuf,NULL);
	}

	return m_pData [uIndex];
}

int _DLLCALL TBibelList::count (void) const
{
	return m_uCount;
}



