// ***************************************
//       Die Bibel fr Windows 3.1 & 95
// ***************************************
//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************
//   Bibeltext- Datenveraltung
//    fr 16- und 32 Bit
// ***************************************
//   BibText.cpp
// ***************************************
#include "bibdll.h"

#ifdef __DLL__
	#define _BIBELTEXTDATA_IMPEX FAR _export
#endif


#include "navigat.h"
#include "bibtext.h"
#include "bibelist.h"


// Konstruktor
TBibelTextData::TBibelTextData (const char *cszFileName,DWORD dwFileSize)
{
	m_dwFileSize = dwFileSize;

	// Pointer auf NULL:
	m_hMiscList = 0;
	m_hMiscMem  = 0;

	m_hWordList = 0;
	m_hWordMem = 0;

	m_hVersIndexList = 0;

	m_hChapterIndexList = 0;

	m_hBookList = 0;
	m_hBookMem = 0;
	m_hBookIndexList = 0;

	m_hPartList = 0;
	m_hPartMem = 0;
	m_hPartIndexList = 0;


   m_dwAbsWordCount = 0;

	m_uLock = 0;
	m_blLoaded = FALSE;
	m_blWasLoaded = FALSE;
	m_dwMemSize= NULL;
	m_szFilename= NULL;

	// Datei ffnen:
	if (!cszFileName)
		EXCEPT ("No valid filename in constructor of TBibelTextData",);

	m_szFilename = strdup (cszFileName);

	m_oFileData.cBytes = sizeof (m_oFileData);
	m_hFile = OpenFile (m_szFilename,&m_oFileData,OF_READ | OF_SHARE_DENY_NONE);

	if (m_hFile == HFILE_ERROR)
		EXCEPT ("Can't open file in constructor of TBibelTextData",);

	// 1. Allgemeine Daten als Stringliste:
	m_dwMemSize = ReadStringList (m_hFile,m_dwMiscCount,m_hMiscList,m_hMiscMem);
   m_dwMemSize += sizeof (this);

	// Allgemeine Daten sind immer verfgbar:
	LockPointer (m_hMiscList,(void**)&m_dwaMiscList);
	LockPointer (m_hMiscMem,(void**)&m_szMiscMem);

	// get position for datas:
	m_dwLoadOffset = _llseek (m_hFile,0,1);


	// close file
	_lclose (m_hFile);
	m_hFile = 0;
}


void TBibelTextData::load (void)
{
	// check, if we should really load it:
   DWORD dwTempSize= m_dwMemSize;

	if (m_blLoaded == TRUE)
		EXCEPT ("This file is allready loaded in load()",);
//		throw new ETextAccessError ("This file is allready loaded in load()");
	if (!m_szFilename)
		EXCEPT ("No valid filename in load ()",);

	m_oFileData.cBytes = sizeof (m_oFileData);
	m_hFile = OpenFile (m_szFilename,&m_oFileData,OF_READ | OF_SHARE_DENY_NONE);
	if (m_hFile == HFILE_ERROR)
		EXCEPT ("Can't open in load ()",);

	if (_llseek (m_hFile,m_dwLoadOffset,0) == HFILE_ERROR)
		EXCEPT ("Cant seek in file in load()",);

	// 2. Wortliste
	dwTempSize += ReadStringList (m_hFile,m_dwWordCount,m_hWordList,m_hWordMem);

	// 3. Versliste
	// Lnge einlesen
	if (_hread (m_hFile,&m_dwVersCount,4) != 4)
		EXCEPT ("Error while loading vers count in load()",);

	dwTempSize += ReadIndexList (m_hFile,m_dwVersCount,m_hVersIndexList); // Liste lesen

	// 4. Kapitelliste
	// Lnge einlesen
	if (_hread (m_hFile,&m_dwChapterCount,4) != 4)
		EXCEPT ("Error while loading chapter count in load()",);


	dwTempSize += ReadIndexList (m_hFile,m_dwChapterCount,m_hChapterIndexList); // Liste lesen

	// 5. Buchliste
	dwTempSize += ReadStringList (m_hFile,m_dwBookCount,m_hBookList,m_hBookMem);
	dwTempSize += ReadIndexList (m_hFile,m_dwBookCount,m_hBookIndexList);

	// 6. Abschnittliste lesen:
	dwTempSize += ReadStringList (m_hFile,m_dwPartCount,m_hPartList,m_hPartMem);
	dwTempSize += ReadIndexList (m_hFile,m_dwPartCount,m_hPartIndexList);


	// 7. Anfangsposition der Wrter ermitteln:
	m_lWordsStartPos = _llseek (m_hFile,0,1);
	m_dwWordsCount =  m_dwFileSize - m_lWordsStartPos;

	// Setzen der letzten Elemente der Indexliste:
	set_last_index_entry (m_hPartIndexList,m_dwPartCount,m_dwBookCount);
	set_last_index_entry (m_hBookIndexList,m_dwBookCount,m_dwChapterCount);
	set_last_index_entry (m_hChapterIndexList,m_dwChapterCount,m_dwVersCount);
	set_last_index_entry (m_hVersIndexList,m_dwVersCount,m_dwWordsCount);


	m_blLoaded = TRUE;
   if (m_blWasLoaded == FALSE)
   {
		m_blWasLoaded = TRUE;
      m_dwMemSize = dwTempSize;
	}

}

void TBibelTextData::set_last_index_entry (HGLOBAL hList,DWORD dwLastIndex,DWORD dwLastElement)
{
	DWORD _huge *dwList = (DWORD _huge*) GlobalLock (hList);
	if (!dwList)
		EXCEPT ("Cant lock global memory in set_last_index_entry()",);

	dwList[dwLastIndex] = dwLastElement;

	GlobalUnlock (hList);
}

void TBibelTextData::unload (void)
{

	if (m_blLoaded == FALSE)
		EXCEPT ("Object is allready loaded in unload()",);

	// Datei schlieen:
	if (m_hFile != HFILE_ERROR)
		_lclose (m_hFile);
	m_hFile = NULL;
	m_blLoaded = FALSE;

	FreeGlobalPointer(m_hWordList);
	FreeGlobalPointer(m_hWordMem);

	FreeGlobalPointer(m_hVersIndexList);


	FreeGlobalPointer(m_hChapterIndexList);


	FreeGlobalPointer(m_hBookList);
	FreeGlobalPointer(m_hBookMem);
	FreeGlobalPointer(m_hBookIndexList);

	FreeGlobalPointer(m_hPartList);
	FreeGlobalPointer(m_hPartMem);
	FreeGlobalPointer(m_hPartIndexList);

}

// Destruktor
TBibelTextData::~TBibelTextData ()
{

	if (m_uLock)
	{
		m_uLock = 1;
		unlock (); // Daten unlocken
	}
	UnlockPointer (m_hMiscList,(void**)&m_dwaMiscList);
	UnlockPointer (m_hMiscMem,(void**)&m_szMiscMem);

	if (m_blLoaded == TRUE)
		unload ();

	FreeGlobalPointer(m_hMiscList);
	FreeGlobalPointer(m_hMiscMem);

	if (m_szFilename)
		free (m_szFilename);
}


// Einlesen einer Liste von Strings aus hFile, die Anzahl wird in iStringCount bertragen,
// Die Liste selbst wird als char-Array in iaStringList erzeugt. Die Strings liegen im
// Speicher von hStringList. iaStringList und hStringList werden mit GlobalAlloc erzeugt
DWORD TBibelTextData::ReadStringList
		(HFILE hFile,DWORD& dwStringCount,HGLOBAL& hStringList,HGLOBAL& hStringMem)
{
	DWORD dwSize;
	struct SRHeader
	{
		DWORD dwCount;
		DWORD dwLen;
	} srHeader;

	DWORD dwIndex,dwStrNum;
	char _huge *cMem;
	DWORD _huge *dwaList;

	// Header einlesen:
	if (_hread (hFile,&srHeader,sizeof (srHeader)) != sizeof (srHeader))
		EXCEPT ("Cant read header in ReadStringList()",0);

	dwStringCount = srHeader.dwCount; // Anzahl zurckgeben

	// Speicher fr die String-Liste allokieren:
	hStringList = GlobalAlloc (GMEM_MOVEABLE | GMEM_DISCARDABLE,(srHeader.dwCount+1) * sizeof (DWORD));
	if (hStringList == 0)
		EXCEPT ("Cant alloc global memory: hStringList in ReadStringList()",0);

	dwSize = (srHeader.dwCount+1) * sizeof (DWORD);

	// Speicher fr Strings allokieren
	hStringMem = GlobalAlloc (GMEM_MOVEABLE | GMEM_DISCARDABLE,srHeader.dwLen);

	if (hStringMem == 0)
		EXCEPT ("Cant alloc global memory: hStringMem in ReadStringList()",0);

	dwSize += srHeader.dwLen;

	// Zeiger ermiteln
	dwaList = (DWORD*) GlobalLock (hStringList);
	if (!dwaList)
		EXCEPT ("Cant lock global memory: dwaList in ReadStringList()",0);

	cMem = (char*) GlobalLock (hStringMem);
	if (!cMem)
		EXCEPT ("Cant lock global memory: cMem in ReadStringList()",0);

	// Strings einlesen:
	if(_hread (hFile,cMem,srHeader.dwLen) != srHeader.dwLen)
		EXCEPT ("Cant read header in ReadStringList()",0);

	// Zeigerliste aufbauen:
	dwaList[0] = 0;
	dwStrNum = 1;
	for (dwIndex = 0;dwIndex < srHeader.dwLen;dwIndex++) {
		// ber gesammten String iterieren:
		if (cMem[dwIndex] == '\0' && dwIndex+1 < srHeader.dwLen &&
				dwStrNum < srHeader.dwCount+1) { // Bei Wortende
							// ist nchstes Zeichen Wortanfang:
			dwaList[dwStrNum++] = dwIndex +1;
		}
	}

	GlobalUnlock (hStringList);

	GlobalUnlock (hStringMem);

	return dwSize;
}

// Einlesen einer Liste von Indizes aus hFile mit dwListCount Elementen
// Die Liste wird in dwaListCount angelegt. Der Speicher mit GlobalAlloc
// angefordert.
DWORD TBibelTextData::ReadIndexList (HFILE hFile,DWORD dwListCount,HGLOBAL& hList)
{
	char far *szBuf;
	int iIndex;
	DWORD dwPos;
	DWORD _huge *dwList;
	DWORD dwMemSize;


	// Da die Daten im 8Bit-Format als Differenzen vorliegen, mssen Sie erst in einem
	// temporren Buffer geladen werden:

	szBuf = (char*) farmalloc (dwListCount);

	if (!szBuf)
		EXCEPT ("Cant alloc szBuf in ReadIndexList()",0);

	// Liste allokieren:
	hList =  GlobalAlloc (GMEM_MOVEABLE | GMEM_DISCARDABLE,(dwListCount+1) * sizeof (DWORD));
	if (hList == 0)
		EXCEPT ("Cant global alloc hList in ReadIndexList()",0);

	dwMemSize = (dwListCount*1) * sizeof (DWORD);

	dwList = (DWORD*) GlobalLock (hList);

	if (!dwList)
		EXCEPT ("Cant global alloc dwList in ReadIndexList()",0);

	// Differenzliste aus Datei einlesen:
	if (_hread (hFile,szBuf,dwListCount) != dwListCount)
		EXCEPT ("Cant read szBuf in ReadIndexList()",0);


	// Indexliste aus Differenzliste aufbauen
	dwPos = 0;
	for (iIndex = 0;iIndex < dwListCount;iIndex++) {
		dwPos += szBuf [iIndex]; // akt. Pos berechnen
		dwList [iIndex] = dwPos; // und speichern
	}


	// Speicher freigeben
	farfree (szBuf);

	GlobalUnlock (hList);

	return dwMemSize;
}


// Pointer lschen, wenn vorhanden:
void TBibelTextData::FreeGlobalPointer (HGLOBAL& hGlobal)
{
	if (hGlobal) {
		if (GlobalFree (hGlobal) != NULL)
			EXCEPT ("Cant freeing global pointer in FreeGlobalPointer()",);
		hGlobal = NULL;
	}
}

// Globale Daten fr den Zugiff locken
void _DLLCALL TBibelTextData::lock (void)
{
#ifdef __WIN32__
	TCriticalSection::Lock l(m_csLock);
#endif
	m_uLock++;

	if (m_uLock == 1)
	{
		if (m_blLoaded == FALSE)
			load ();
		LockPointer (m_hWordList,(void**)&m_lkdwaWordList);
		LockPointer (m_hWordMem,(void**)&m_lkszWordMem);

		LockPointer (m_hVersIndexList,(void**)&m_lkdwaVersIndexList);

		LockPointer (m_hChapterIndexList,(void**)&m_lkdwaChapterIndexList);

		LockPointer (m_hBookList,(void**)&m_lkdwaBookList);
		LockPointer (m_hBookMem,(void**)&m_lkszBookMem);
		LockPointer (m_hBookIndexList,(void**)&m_lkdwaBookIndexList);

		LockPointer (m_hPartList,(void**)&m_lkdwaPartList);
		LockPointer (m_hPartMem,(void**)&m_lkszPartMem);
		LockPointer (m_hPartIndexList,(void**)&m_lkdwaPartIndexList);

	}
}

// Globale Daten freigeben, und so im Speicher verschiebbar machen:
void _DLLCALL TBibelTextData::unlock (void)
{
#ifdef __WIN32__
	TCriticalSection::Lock l(m_csLock);
#endif

	if (!m_uLock)
		EXCEPT ("Unlock too often in unlock()",);

	m_uLock--;

	if (!m_uLock)
	{
		UnlockPointer (m_hWordList,(void**)&m_lkdwaWordList);
		UnlockPointer (m_hWordMem,(void**)&m_lkszWordMem);

		UnlockPointer (m_hVersIndexList,(void**)&m_lkdwaVersIndexList);

		UnlockPointer (m_hChapterIndexList,(void**)&m_lkdwaChapterIndexList);

		UnlockPointer (m_hBookList,(void**)&m_lkdwaBookList);
		UnlockPointer (m_hBookMem,(void**)&m_lkszBookMem);
		UnlockPointer (m_hBookIndexList,(void**)&m_lkdwaBookIndexList);

		UnlockPointer (m_hPartList,(void**)&m_lkdwaPartList);
		UnlockPointer (m_hPartMem,(void**)&m_lkszPartMem);
		UnlockPointer (m_hPartIndexList,(void**)&m_lkdwaPartIndexList);

		unload ();
	}
}

// Pointer locken
void TBibelTextData::LockPointer (HGLOBAL hGlobal,void **pPtr)
{
	if (hGlobal)
	{
		*pPtr = GlobalLock (hGlobal);
		if (!pPtr)
			EXCEPT ("Cant lock global pointer in LockPointer()",);
	}
}

// Pointer unlocken
void TBibelTextData::UnlockPointer (HGLOBAL hGlobal,void **pPtr)
{
	if (hGlobal)
		GlobalUnlock (hGlobal);
	*pPtr = NULL;

}

// throw execption, if not locked or not loaed:
void TBibelTextData::check_lock_load (void) const
{
	if (!m_uLock) // no lock no access
		EXCEPT ("Bibel is not locked",);
	if (m_blLoaded == FALSE)
		EXCEPT ("Accessing  not loaded Bibel in check_lock_load()",);
}

// Name der bersetzung abfragen
const char far * _DLLCALL TBibelTextData::name (void) const
{
	if (m_dwMiscCount > 0)
		return (char far*)(char _huge*)(m_szMiscMem + (int) m_dwaMiscList [0]);
	else
		return "No Name";
}

// Copyright abfragen:
const char far* _DLLCALL TBibelTextData::copyright (void) const
{
	if (m_dwMiscCount > 1)
		return (char far*)(char _huge*)(m_szMiscMem +  (int)m_dwaMiscList [1]);
	else
		return "No Copyright";
}


const char far* _DLLCALL TBibelTextData::part_name (DWORD dwIndex) const // Abschnittsname ermitteln
{
	check_lock_load ();

	if (dwIndex < m_dwPartCount)
		return (char far*)(char _huge*)(m_lkszPartMem + m_lkdwaPartList [dwIndex]);

#ifdef _EXCEPT_
	char szBuf [200];
	sprintf (szBuf,"part_name: index too big:%X (0-%X) in part_name()",dwIndex,m_dwPartCount-1);
#endif
	EXCEPT (szBuf,0);
}

// Zugriffsfunktionen auf Buchdaten:
DWORD _DLLCALL TBibelTextData::book_count (DWORD dwPartNr) const // Anzahl der Bcher ermitteln
{
	check_lock_load ();

	return part_index (dwPartNr+1) - part_index (dwPartNr);
}


const char far* _DLLCALL TBibelTextData::book_name (DWORD dwPartNr,DWORD dwBookNr) const// Bchername ermitteln
{
	check_lock_load ();

	DWORD dwPartIndex = part_index (dwPartNr);

	if ((part_index (dwPartNr+1) - dwPartIndex) <= dwBookNr)
		EXCEPT ("Book number too big in book_name()",0);

	dwBookNr += dwPartIndex;

	if (dwBookNr < m_dwBookCount)
		return (char far*) (char _huge*)(m_lkszBookMem + m_lkdwaBookList [dwBookNr]);

#ifdef _EXCEPT_
	char szBuf [200];
	sprintf (szBuf,"book_name: index too big:%X (0-%X) in book_name()",dwBookNr,m_dwBookCount-1);
#endif

	EXCEPT (szBuf,0);

}

// Zugriffsfunktionen auf Kapiteldaten:
// Anzahl der Kapitel ermitteln
DWORD _DLLCALL TBibelTextData::chapter_count (DWORD dwPartNr,DWORD dwBookNr) const
{
	check_lock_load ();

	DWORD dwPartIndex = part_index (dwPartNr);

	if ((part_index (dwPartNr+1) - dwPartIndex) <= dwBookNr)
		EXCEPT ("Book number too big in chapter_count()",0);

	dwBookNr += dwPartIndex;

	return book_index (dwBookNr+1) - book_index (dwBookNr);
}


// Zugriffsfunktionen auf Versdaten:
// Anzahl der Verse ermitteln
DWORD _DLLCALL TBibelTextData::vers_count (DWORD dwPartNr,DWORD dwBookNr,DWORD dwChapterNr) const
{
	check_lock_load ();

	DWORD dwPartIndex = part_index (dwPartNr);

	if ((part_index (dwPartNr+1) - dwPartIndex) <= dwBookNr)
		EXCEPT ("Book number too big in vers_count()",0);

	dwBookNr += dwPartIndex;

	DWORD dwBookIndex = book_index (dwBookNr);

	if ((book_index (dwBookNr+1) - dwBookIndex) <= dwChapterNr)
		EXCEPT ("Chapter number too big in vers_count()",0);

	dwChapterNr += dwBookIndex;

	return chapter_index (dwChapterNr+1) - chapter_index (dwChapterNr);
}

DWORD _DLLCALL TBibelTextData::part_index (DWORD dwIndex) const// Abchnittsindex einer Abschnittseintragung ermitteln
{

	if (dwIndex <= m_dwPartCount)
		return m_lkdwaPartIndexList [dwIndex];

#ifdef _EXCEPT_
	char szBuf [200];
	sprintf (szBuf,"part_index too big:%X (0-%X) in part_index()",dwIndex,m_dwPartCount-1);
#endif

	EXCEPT  (szBuf,0);

}


DWORD _DLLCALL TBibelTextData::book_index (DWORD dwIndex) const// Bcherindex einer Bucheintragung ermitteln
{
	if (dwIndex > m_dwBookCount)
	{
 #ifdef _EXCEPT_
		char szBuf [200];
		sprintf (szBuf,"book_index too big:%X (0-%X) in book_index()",dwIndex,m_dwBookCount-1);
 #endif

		EXCEPT  (szBuf,0);
	}

	return m_lkdwaBookIndexList [(int)dwIndex];
}


// Kapitelindex einer Kapiteleintragung ermitteln
DWORD _DLLCALL TBibelTextData::chapter_index (DWORD dwIndex) const
{

	if (dwIndex <= m_dwChapterCount)
		return m_lkdwaChapterIndexList [(int)dwIndex];

#ifdef _EXCEPT_
	char szBuf [200];
	sprintf (szBuf,"chapter_index too big:%X (0-%X) in chapter_index()",dwIndex,m_dwChapterCount-1);
#endif

	EXCEPT  (szBuf,0);
}

DWORD _DLLCALL TBibelTextData::vers_index (DWORD dwIndex) const// Verseindex einer Verseintragung ermitteln
{

	if (dwIndex <= m_dwVersCount)
		return m_lkdwaVersIndexList [(int)dwIndex];

#ifdef _EXCEPT_
	char szBuf [200];
	sprintf (szBuf,"vers_index too big:%X (0-%X) in vers_index()",dwIndex,m_dwVersCount-1);
#endif

	EXCEPT  (szBuf,0);
}

// fill Buffer with Bibel-Text
BOOL _DLLCALL TBibelTextData::fill_buffer (DWORD dwBufSize,char _huge *szBuffer,
		const INavigator far *pIBegin,DWORD lVersCount)
{
	const TNavigator far* pBegin= (const TNavigator far*)pIBegin;

	check_lock_load ();

	if (!dwBufSize || !szBuffer)
		EXCEPT ("Buffer not valid in fill_buffer()",FALSE);

	if (!pBegin)
		EXCEPT ("Navigator not valid in fill_buffer()",FALSE);

	if (!lVersCount)
		EXCEPT ("Should fill buffer with NULL words in fill_buffer()",FALSE);

	char _huge *c = szBuffer;
	DWORD dwFirstVers = pBegin -> m_dwAbsVers;
	DWORD dwWordStart = vers_index (dwFirstVers);
	DWORD dwFilePos = m_lWordsStartPos + dwWordStart;
	DWORD dwLastVers = dwFirstVers + lVersCount;
	DWORD dwWordIndex;

	if (dwLastVers > absolute_vers_count ())
	{
 #ifdef _EXCEPT_
		char bfText [512];
		sprintf (bfText,"Try to read from vers %i to vers %i, but this bibel goes only to vers %i in fill_buffer()",
			(long)dwFirstVers,(long)dwLastVers,(long)absolute_vers_count ());
 #endif
		EXCEPT  (bfText,FALSE);
	}

	DWORD dwReadLen= vers_index (dwLastVers) - dwWordStart;
	DWORD i;

	dwBufSize--; // reserve one char for zerotermination

	HGLOBAL hBuffer = GlobalAlloc (GMEM_FIXED,dwReadLen);
	if (!hBuffer)
		EXCEPT  ("Cant alloc buffer in fill_buffer()",FALSE);

	char _huge *szWordListBuffer = (char _huge *)GlobalLock (hBuffer);
	char _huge *szWord;

	if (!szWordListBuffer)
		EXCEPT  ("Cant alloc buffer in fill_buffer()",FALSE);

	if (_llseek (m_hFile,dwFilePos,0) == HFILE_ERROR)
		EXCEPT  ("Cant seek file in fill_buffer()",FALSE);

	if (_hread (m_hFile,szWordListBuffer,
		dwReadLen) != dwReadLen)
			EXCEPT ("Error while loading word datas in fill_buffer()",FALSE);

	BOOL blNoSpace = TRUE;
	BOOL blNoSpaceNext = FALSE;

	for (i=0;i<dwReadLen;i++)
	{
		dwWordIndex = szWordListBuffer [i];// & 0x7f;


		if ((dwWordIndex & 1) == 1) { // Handlelt es sich um ein 15 Bit oder ein 8 Bit Wort?
			// 15 Bit:
			dwWordIndex = ((DWORD)(dwWordIndex >> 1) | ((DWORD)((DWORD)szWordListBuffer [++i]) << 7));
		} else {
			// 7 Bit Wort:
			dwWordIndex = (dwWordIndex >> 1);
		}

		// is result valid?
		if (dwWordIndex >= m_dwWordCount)
			EXCEPT("Invalid Word index in fill_buffer()",FALSE);

		szWord = m_lkszWordMem + m_lkdwaWordList[dwWordIndex];

		DWORD dwLen = _fstrlen ((char far*)szWord);

		if (dwLen >= dwBufSize)
		{  // not enougt buffer size!
			*c = '\0';

			GlobalUnlock (hBuffer);
			GlobalFree (hBuffer);

			return FALSE;
		}

		if (dwLen == 1)
		{
			switch (*szWord) {
				case '.' :
				case ':' :
				case ',' :
				case ';' :
				case '!' :
				case '?' :
				case ')' :
				case '}' :
					blNoSpace = TRUE;
					break;
				case '(' :
				case '{' :
					blNoSpaceNext = TRUE;
					break;
			}

		}

		if (blNoSpace == FALSE)
		{
			*c = ' ';
			c++;
			dwBufSize--;
		}

		if (blNoSpaceNext == TRUE)
		{
			blNoSpaceNext = FALSE;
			blNoSpace = TRUE;
		}
		else
			blNoSpace = FALSE;

		// copy word:
		while (*szWord)
		{
			*c = *szWord;
			c++;
			szWord++;
			dwBufSize--;
		}
	}

	// terminate:
	*c = '\0';
	GlobalUnlock (hBuffer);
	GlobalFree (hBuffer);

	return TRUE;
}

DWORD _DLLCALL TBibelTextData::mem_size (void)
{
	if (m_blWasLoaded == FALSE)
	{
		load ();
		unload ();
	}

	return m_dwMemSize;
}

DWORD _DLLCALL TBibelTextData::absolute_part_count (void)
{
	if (m_blWasLoaded == FALSE)
	{
		load ();
		unload ();
	}

	return m_dwPartCount;
}

DWORD _DLLCALL TBibelTextData::absolute_book_count (void)
{
	if (m_blWasLoaded == FALSE)
	{
		load ();
		unload ();
	}

	return m_dwBookCount;
}

DWORD _DLLCALL TBibelTextData::absolute_chapter_count (void)
{
	if (m_blWasLoaded == FALSE)
	{
		load ();
		unload ();
	}

	return m_dwChapterCount;
}

DWORD _DLLCALL TBibelTextData::absolute_vers_count (void)
{
	if (m_blWasLoaded == FALSE)
	{
		load ();
		unload ();
	}

	return m_dwVersCount;
}

DWORD _DLLCALL TBibelTextData::absolute_word_count (void)
{
	if (m_blWasLoaded == FALSE)
	{
		load ();
		unload ();
	}

	if (m_dwAbsWordCount == 0)
	{
		const DWORD cdwBufSize = 0x00040000L;

		DWORD dwFilePos = m_lWordsStartPos;
		DWORD dwBufPos;
		DWORD dwLeftBytesToRead = m_dwWordsCount;
		DWORD dwReadLen; // Bytes aktual read in buffer
		BOOL blLastWordNotComplete;

		// evaluate word count:
		char _huge *szWordListBuffer = (char _huge*)farmalloc (cdwBufSize);

		if (!szWordListBuffer)
			EXCEPT  ("Cant alloc buffer in absolute_word_count()",NULL);


		while (dwLeftBytesToRead)
		{
			// Calc Bytes to read:
			if (dwLeftBytesToRead >= cdwBufSize)
				dwReadLen = cdwBufSize;
			else
				dwReadLen = dwLeftBytesToRead;

			dwBufPos = 0;
			blLastWordNotComplete = FALSE;

			if (_llseek (m_hFile,dwFilePos,0) == HFILE_ERROR)
				EXCEPT  ("Cant seek file in absolute_word_count()",FALSE);
			// Fill Buffer
			if (_hread (m_hFile,szWordListBuffer,
				dwReadLen) != dwReadLen)
					EXCEPT ("Error while loading word datas in absolute_word_count()",NULL);


			// work in buffer...
			while (dwBufPos < dwReadLen)
			{
				if ((szWordListBuffer [dwBufPos] & 1) == 1)
				{
					dwBufPos++;
					if (dwBufPos == dwReadLen)
					{
						dwReadLen--; // proceed last byte again
						blLastWordNotComplete = TRUE;
						break;
					}
				}
				dwBufPos++;
				m_dwAbsWordCount++;


			}
			dwLeftBytesToRead -= dwReadLen;

			if (!dwLeftBytesToRead)
				break;

			dwFilePos += dwBufPos;
			if (blLastWordNotComplete == TRUE && (dwLeftBytesToRead < 2))
				EXCEPT ("Wordlist is not valid in absolute_word_count()",NULL);
		}

		farfree (szWordListBuffer);

	}

	return m_dwAbsWordCount;
}









