// ***************************************
//       Die Bibel fr Windows 3.1 & 95
// ***************************************
//   (c) 1996 by Olaf Panz
//		 Drosselgasse 4
//
//     21436 Marschacht
// ***************************************
//   Bibelzugriff aus Dialog heraus
// ***************************************
//   BibAcc16.cpp
// ***************************************
#include <bibel.h>
#include <buffers.h>


// Bibel ffnen und darstellen
void OpenBibel (HWND hWnd,int iBibel)
{
	DWORD dwPartCount,i;//dwLastBook,j;
	HWND hPart = GetDlgItem (hWnd,ID_Part);
	HMENU hMenu = GetMenu (hWnd); // Men ermitteln


	pBibelData = (TBibelTextData*)glpBibelList -> data (iBibel);
	pBibelData -> lock ();

	pNavigator = pNavList [iBibel];

	const char cszCaption [] = "Die Bibel - ";
	const char *cszName = pBibelData -> name ();
	TBuffer szCaptionBuf (strlen (cszCaption) + strlen (cszName) +1);
	strcpy (szCaptionBuf,cszCaption);
	strcat (szCaptionBuf,cszName);
	SendMessage (hWnd,WM_SETTEXT,0,(long)szCaptionBuf);


	// Meneintrag markieren
	CheckMenuItem (hMenu,iBibel + CM_TranslationFirst,MF_CHECKED | MF_BYCOMMAND);


	// Alle Abschnitte in die Combobox einfgen:
	dwPartCount = pBibelData -> part_count ();
	for (i=0;i < dwPartCount;i++)
      ComboBox_AddString (hPart,pBibelData -> part_name (i));
//		SendMessage (hPart,CB_ADDSTRING,(WPARAM)0,(LPARAM)pBibelData -> part_name (i));

	ComboBox_SetCurSel (hPart,pNavigator -> part());
  //	SendMessage (hPart,CB_SETCURSEL,pNavigator -> part(),0);

	// Scroll range setzen:
	SetScrollRange (hWnd,SB_VERT,0,(int)pBibelData -> absolute_vers_count() -1,FALSE);

	// Buchliste in Listbox einfgen
	UpdateBookList (hWnd,pNavigator);

}

// Akt. dargestellte Bibel schlieen,
// Darstellung lschen:
void CloseBibel (HWND hWnd, int iBibel)
{
	HMENU hMenu = GetMenu (hWnd); // Men ermitteln

	// Meneintrag markieren
	CheckMenuItem (hMenu,iBibel + CM_TranslationFirst,MF_UNCHECKED | MF_BYCOMMAND);

	// Bibel im Speicher freigeben
	pBibelData -> unlock ();

	// Abschnittsliste lschen
   ComboBox_ResetContent (GetDlgItem (hWnd,ID_Part));
//	SendDlgItemMessage (hWnd,ID_Part,CB_RESETCONTENT,0,0);

	// Kapitelliste lschen:
   ListBox_ResetContent (GetDlgItem (hWnd,ID_List));
//	SendDlgItemMessage (hWnd,ID_List,LB_RESETCONTENT,0,0);

}

// Bcherliste updaten
// nur 16Bit!!
void UpdateBookList (HWND hWnd,TNavigator *pNav)
{
	// Listbox-Handle ermitteln:
	HWND hList = GetDlgItem (hWnd,ID_List);
	DWORD dwPart,i,dwMax;

	// Liste lschen:
   ListBox_ResetContent (hList);
//	SendMessage (hList,LB_RESETCONTENT,0,0);

	// Abschnitt ermitteln:
	dwPart = pNav -> part ();
	// Anfangsindex ermitteln:
	dwMax = pBibelData -> book_count (dwPart);

	// Namen eintragen:
	for (	i =  0;i < dwMax ;i++)
   	ListBox_AddString (hList,pBibelData -> book_name (dwPart,i));
//		SendMessage (hList,LB_ADDSTRING,0,(long)pBibelData -> book_name (dwPart,i));

	UpdateText (hWnd,pNav);
}

BOOL add_text (const char far *cszNewString,char far *pBuffer,int& iFreeBuf,int& iBufIndex)
{
	int len = strlen (cszNewString);

	if (iFreeBuf <= len)
		return FALSE;

	memcpy (pBuffer+iBufIndex,cszNewString,len);
	iFreeBuf 	-= len;
	iBufIndex 	+= len;

	return TRUE;
}


// Textanzeige upaten:
void UpdateText (HWND hWnd,TNavigator *pNav)
{
	HLOCAL hMem;
	HWND hText = GetDlgItem (hWnd,ID_TextControl);
	HWND hPart = GetDlgItem (hWnd,ID_Part);
	unsigned uTextBufLen = iLineCount * iLineLength;
	BOOL blFirstVers = TRUE;

   if (!uTextBufLen)
   	return;


	char *pBuf;
	int iMax;
	TNavigator oLocalNav (*pNav); // Lokalen Navigator erzeugen, beginnend ab original Navigator

	iLastSecondVersOffset = iSecondVersOffset;

	// Hierachische Navigationselemente anpassen:
	iMax = ComboBox_GetCurSel (hPart);

	if (iMax != pNav -> absolute_part ())
	{
		ComboBox_SetCurSel (hPart,pNav -> absolute_part());
		UpdateBookList (hWnd,pNav);
		return; // hier ist ende, da UpdateBookList diese Funktion aufruft!!
	}

   ListBox_SetCurSel (GetDlgItem (hWnd,ID_List),pNav -> book());


#ifndef __WIN32__
	// Buffer des Textcontrols anpassen:
   hMem = Edit_GetHandle (hText);
	// Stimmt die Buffergre?
	if (LocalSize (hMem) != uTextBufLen)
	{
		LocalFree (hMem); // Nein, also freigeben
#endif
		// und neu erzeugen:
		hMem = LocalAlloc (LMEM_MOVEABLE,uTextBufLen);
#ifndef __WIN32__
	}
#endif


	int iFreeBuf = LocalSize (hMem) -1;
	int iBufIndex = 0;

	// Speicher zum Benutzen locken:
	pBuf = (char far *) LocalLock (hMem);
	const char far *c;

	while (iFreeBuf > 0)
	{
		c = pBibelData -> book_name (oLocalNav.part (),oLocalNav.book());
		// first: add headline
		if (add_text (c,pBuf,iFreeBuf,iBufIndex) == FALSE)
			break;

		char szBuf [100];
		szBuf [0] = ' ';
		itoa (oLocalNav.chapter ()+1,szBuf + 1,10);
		strcat (szBuf,",");
		itoa (oLocalNav.vers () +1,szBuf + strlen (szBuf),10);

		strcat (szBuf,"\r\n");

		// add separator
		if (add_text (szBuf,pBuf,iFreeBuf,iBufIndex) == FALSE || !iFreeBuf)
			break;


		// add text of vers
		if (pBibelData -> fill_buffer (iFreeBuf,pBuf + iBufIndex,&oLocalNav,1)
			== FALSE)
				break;

		int len = strlen (pBuf + iBufIndex);
		iBufIndex += len;
		iFreeBuf -= len;

		if (oLocalNav.next () == FALSE)
			break;

		// add new line
		if (add_text ("\r\n",pBuf,iFreeBuf,iBufIndex) == FALSE)
			break;

		if (blFirstVers == TRUE)
		{
			blFirstVers = FALSE;
         iSecondVersOffset = iBufIndex;
		}

	}





#ifndef __WIN32__

	// Speicherzugriff wieder freigeben:
	LocalUnlock (hMem);
	// und dem Dialogelement schicken:
   Edit_SetHandle (hText,hMem);
#else
	SendMessage (hText,WM_SETTEXT,0,(long)pBuf);

   LocalUnlock (hMem);
   LocalFree (hMem);
#endif

		// Slider init:
	SetScrollPos (hWnd,SB_VERT,(int)pNav -> absolute_vers (),TRUE);

//	int iLastLineIndex = (int)SendMessage (hText,EM_LINEINDEX,iLineCount-1,0);
	int iLastLineIndex = Edit_LineIndex (hText,iLineCount-1);

	iLastVisibleChar = Edit_LineLength (hText,iLastLineIndex) + iLastLineIndex;


//	iLastVisibleChar = (int)SendMessage (hText,EM_LINELENGTH,iLastLineIndex,0)
  // 	+ iLastLineIndex;

}



