// ***************************************
//       Die Bibel fr Windows 3.1 & 95
// ***************************************
//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************
//   Bibeltext- Small-Viewer
// ***************************************
//   Copy to Clipboard Dialog
// ***************************************
//   copyclip.cpp
// ***************************************
#include <bibel.h>

struct SRCopyClipParam
{
	TNavigator far *pFrom;
	TNavigator far *pTo;
};

void UpdateNavText (HWND hWnd,TNavigator far *pNav)
{
	char szBuf [256];
	pNav -> position_name (szBuf,256);

	SendMessage (hWnd,WM_SETTEXT,0,(long)szBuf);
}

BOOL CALLBACK CopyClipDialogProc(
	 HWND  hWnd,	// handle of dialog box
	 UINT  uMsg,	// message
	 WPARAM  wParam,	// first message parameter
	 LPARAM  lParam 	// second message parameter
	)
{
	static SRCopyClipParam *pParam;

	switch (uMsg)
	{
		case WM_INITDIALOG :
		{
			pParam = (SRCopyClipParam*)lParam;

			UpdateNavText (GetDlgItem (hWnd,DLG_1),pParam -> pFrom);
			UpdateNavText (GetDlgItem (hWnd,DLG_3),pParam -> pTo);

			return 1;
		}
		case WM_COMMAND :
			switch (LOWORD(wParam))
			{
				case IDOK :
					EndDialog (hWnd,TRUE);
					return 1;
				case IDCANCEL :
					EndDialog (hWnd,FALSE);
					return 1;
				case IDHELP :
					MessageBox (hWnd,"Comes later...","Help",MB_OK);
					return 1;
				case DLG_2 :
					if (goto_dialog (hWnd,pParam -> pFrom,"Kopieren von...") == TRUE)
					{
						UpdateNavText (GetDlgItem (hWnd,DLG_1),pParam -> pFrom);
						if (pParam -> pFrom -> absolute_vers() > pParam -> pTo -> absolute_vers())
						{
							pParam -> pTo -> set_pos (pParam -> pFrom);
							UpdateNavText (GetDlgItem (hWnd,DLG_3),pParam -> pTo);
						}
					}
					return 1;
				case DLG_4 :
					if (goto_dialog (hWnd,pParam -> pTo,"Kopieren bis...") == TRUE)
					{
						UpdateNavText (GetDlgItem (hWnd,DLG_3),pParam -> pTo);
						if (pParam -> pFrom -> absolute_vers() > pParam -> pTo -> absolute_vers())
						{
							pParam -> pFrom -> set_pos (pParam -> pTo);
							UpdateNavText (GetDlgItem (hWnd,DLG_1),pParam -> pFrom);
						}
					}
					return 1;
			}
			break;


	}
	return 0;
}

void copyclip_dialog (HWND hParent,TNavigator *pNav)
{
	SRCopyClipParam oParam;
	TNavigator oFromNav (*pNav);
	TNavigator oToNav (*pNav);
	oParam.pFrom = &oFromNav;
	oParam.pTo = &oToNav;
	int iErg;

#ifndef __WIN32__
	FARPROC fpProc = MakeProcInstance ((FARPROC)CopyClipDialogProc,glhInstance);
#else
	FARPROC fpProc = (FARPROC)CopyClipDialogProc;
#endif

	iErg = DialogBoxParam (glhInstance,MAKEINTRESOURCE (CopyClipboard_DLG),hParent,
		(DLGPROC)fpProc,(long)&oParam);

#ifndef __WIN32__
	FreeProcInstance (fpProc);
#endif

	if (iErg == TRUE)
	{
		HGLOBAL hGlobal;
		const DWORD cdwMemAdd = 0x00100000L;
		DWORD dwMemSize = 1024;
		BOOL blErg;
		DWORD dwVersCount = oParam.pTo -> absolute_vers () -
									oParam.pFrom -> absolute_vers () +1;

		HCURSOR hcurSave = SetCursor(LoadCursor(NULL, IDC_WAIT));

		do {

			hGlobal = GlobalAlloc (GMEM_MOVEABLE,dwMemSize);
			if (hGlobal == NULL)
			{
				SetCursor (hcurSave);
				MessageBox (hParent,"Speicher zum Kopieren kann nicht erzeugt werden.",
					"Fehler",MB_ICONHAND | MB_OK);
				return;
			}

			char _huge *pBuf = (char _huge *)GlobalLock (hGlobal);

			if (!pBuf)
			{
				SetCursor (hcurSave);
				MessageBox (hParent,"Speicher zum Kopieren kann nicht erzeugt werden.",
					"Fehler",MB_ICONHAND | MB_OK);
				return;
			}

			blErg = pNav -> text_data () -> fill_buffer (dwMemSize,
				pBuf,&oFromNav,dwVersCount);

			if (blErg == FALSE)
			{
				GlobalUnlock (hGlobal);
				GlobalFree (hGlobal);
				dwMemSize += cdwMemAdd;
			}

		} while (blErg == FALSE);

		GlobalUnlock (hGlobal);

		// Copy to clipboard here!
		if (OpenClipboard (hMainWin) == FALSE)
		{
			MessageBox (hParent,"Die Zwischenablage kann nicht geffnet werden!","Fehler",MB_ICONHAND | MB_OK);
			return;
		}
		SetClipboardData (CF_TEXT,hGlobal);
		CloseClipboard ();
		SetCursor (hcurSave);
	}



}

