// ***************************************
//       Die Bibel fr Windows 3.1 & 95
// ***************************************
//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************
//   DLL-Main
// ***************************************
//   DLLMain.H
// ***************************************
#include "bibdll.h"

#include "navigat.h"
#include "bibtext.h"
#include "bibelist.h"



TBibelList far *stpList = NULL;

class EDllInitError
{
	public :

		EDllInitError (const char *cszText)
			{ MessageBox (0,cszText,"Error in module dllmain",MB_OK | MB_ICONHAND); }
};


extern "C" {

#ifdef __WIN32__


BOOL  WINAPI _export DllEntryPoint (HINSTANCE hinstDll, DWORD fdwReason,
								  LPVOID /*lpvReserved*/)
{

	switch (fdwReason)
	{

		case DLL_PROCESS_ATTACH :
			stpList = new TBibelList (hinstDll);
			if (!stpList)
				throw new EDllInitError ("Cant create Bibel list in DllEntryPoint()");
			break;

		case DLL_PROCESS_DETACH :
			delete stpList;
			stpList = NULL;
			break;
	}

	return TRUE;
}

#else

int CALLBACK LibMain(HINSTANCE hInstance,WORD /*wDataSeg*/,WORD /*cbHeapSize*/,
		LPSTR /*lpszCmdLine*/)
{
	stpList = new TBibelList (hInstance);
	if (!stpList)
		throw new EDllInitError ("Cant create Bibel list in LibMain()");

	return 1;
}

int CALLBACK WEP(int /*nExitType*/)
{
	if (stpList)
		delete stpList;
	stpList = NULL;

	return 1;
}


#endif

IBibelList* _stdcall _export bibel_list (void)
{
	return (IBibelList*)stpList;
}


} // extern "C"

