// ***************************************
//       Die Bibel fr Windows 3.1 & 95
// ***************************************
//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************
//   Installer
// ***************************************
//   Installationsmethoden
// ***************************************
//   doinst.cpp
// ***************************************
#include <install.h>

#define INSTALL_16BIT	1
#define INSTALL_32BIT	2


struct SRFiles
{
   const char *cszSourceName;
	const char *cszTargetName;
   int iFlag;
};

static SRFiles srFiles [] = {
{	"Bibel16.exe",	"bibel.exe",	INSTALL_16BIT },
{	"Bibel32.exe",	"bibel.exe",	INSTALL_32BIT },
{	"*.bib",			NULL,				INSTALL_16BIT | INSTALL_32BIT		},
{	NULL,				NULL,				NULL		 	  }
};



static const int stiExecuteIndex=0; // index of file to execute after install

struct SRLink
{
	const char *cszFile;
	const char *cszName;
};

static const char cszLinkFolder[] = "Die Freeware Bibel";


static SRLink srLinks [] = {
{	"Bibel.exe","Die Bibel" },
{ 	NULL,NULL					}
};

BOOL CALLBACK ProgressDialogProc(
	 HWND  hWnd,	// handle of dialog box
	 UINT  uMsg,	// message
	 WPARAM  /*wParam*/,	// first message parameter
	 LPARAM  /*lParam*/	// second message parameter
	)
{
	switch (uMsg)
	{
		case WM_INITDIALOG :
			center_window (hWnd);
			break;
	}
	return 0;
}



// Deklaration von Methoden
int DoInstall (HWND hParent)
{
	HWND hProgress;
   int iInstallFlag;

	DWORD dwVersion =  GetVersion ();

   int iWinRev = HIBYTE (LOWORD (dwVersion));
   int iWinVer = LOBYTE (LOWORD (dwVersion));

   if (iWinVer >= 4 || (iWinVer == 3) && iWinRev > 20)
		 iInstallFlag = INSTALL_32BIT;
   else
	    iInstallFlag = INSTALL_16BIT;
	// Erzeuge Fortschrittsanzeige

#ifndef __WIN32__
	FARPROC fpProc = MakeProcInstance ((FARPROC)ProgressDialogProc,glhInstance);
#else
	FARPROC fpProc = (FARPROC)InstallDialogProc;
#endif

	hProgress = CreateDialog (glhInstance,MAKEINTRESOURCE (Progress_DLG),hParent,(DLGPROC)fpProc);

	SendDlgItemMessage (hProgress,DLG_1,WM_SETTEXT,0,(long)"Erzeuge Verzeichnis...");
	SendDlgItemMessage (hProgress,DLG_2,WM_SETTEXT,0,(long)glszInstallPath);

	if (create_path (glszInstallPath) == FALSE)
	{
		MessageBox (hParent,"Das Installationsverzeichnis konnte nicht erzeugt werden.",
			"Fehler:",MB_ICONHAND | MB_OK);
		return DLG_BREAK;
	}


	// Installpath in WIN.INI
	WriteProfileString ("DieBibel","Pfad",glszInstallPath);

	// Copy files:
	int iFileNr;
	ffblk ff;
	char szBuf [MAX_PATH];
	char szDest [2*MAX_PATH];
	char szSource [2*MAX_PATH];
	int iErg;

	SendDlgItemMessage (hProgress,DLG_1,WM_SETTEXT,0,(long)"Kopiere Dateien...");
	SendDlgItemMessage (hProgress,DLG_2,WM_SETTEXT,0,(long)"");

	for (iFileNr=0;srFiles[iFileNr].cszSourceName;iFileNr++)
	{
		int j;
		char cLastChar;
		BOOL blDontCopy;
		for (j=0;j < 2;j++)
		{
			// look for uncompressed files:
			strcpy (szBuf,glszModulePath);
			add_slash (szBuf);

       	if ((srFiles[iFileNr].iFlag & iInstallFlag) == NULL)
         	continue;

         strcat (szBuf,srFiles[iFileNr].cszSourceName);

			if (j==1)
			{
				cLastChar = szBuf [strlen (szBuf)-1];
				szBuf [strlen(szBuf)-1] = '_';
			}

			iErg = findfirst (szBuf,&ff,0);
			while (!iErg)
			{
				strcpy (szDest,glszInstallPath);
				add_slash (szDest);

            if (srFiles[iFileNr].cszTargetName)
            {
            	strcat (szDest,srFiles[iFileNr].cszTargetName);
            }
            else
            {
					strcat (szDest,ff.ff_name);
					if (j==1)
						szDest[strlen (szDest)-1] = cLastChar;
            }

				strupr (szDest);
				SendDlgItemMessage (hProgress,DLG_2,WM_SETTEXT,0,(long)szDest);

				strcpy (szSource,glszModulePath);
				add_slash (szSource);
				strcat (szSource,ff.ff_name);

				blDontCopy = is_dest_newer (szDest,szSource);

				if (blDontCopy == TRUE)
				{
					char szMsg [2*MAX_PATH];
					sprintf (szMsg,
						"Die Datei %s ist neuer, als die Datei, die installiert werden soll. Soll diese Datei wirklich installiert werden?",
						szDest);

					if (MessageBox (hParent,szMsg,"Neuere Datei",MB_YESNO | MB_ICONHAND) == IDYES)
						blDontCopy = FALSE;
				}

				if (blDontCopy == FALSE)
				{
					if (copy_file (szDest,szSource) == FALSE)
					{
						sprintf (szDest,"Die Datei %s kann nicht kopiert werden.",szSource);
						MessageBox (hParent,szDest,"Fehler:",MB_OK | MB_ICONHAND);
						return DLG_BREAK;
					}
				}

				iErg = findnext (&ff);
			}
		}
	}

	SendDlgItemMessage (hProgress,DLG_1,WM_SETTEXT,0,(long)"Erzeuge Verknpfungen...");
	SendDlgItemMessage (hProgress,DLG_2,WM_SETTEXT,0,(long)"");

	if (glblShouldCreateLink == TRUE)
	{
		// create link-folder
		sprintf (szDest,"[CreateGroup(\"%s\")]",cszLinkFolder);
		progman_execute (szDest);

		for (iFileNr=0;srLinks[iFileNr].cszFile;iFileNr++)
		{
			SendDlgItemMessage (hProgress,DLG_2,WM_SETTEXT,0,(long)srLinks[iFileNr].cszName);

			// create filename
			strcpy (szDest,glszInstallPath);
			add_slash (szDest);
			strcat (szDest,srLinks[iFileNr].cszFile);


			// Create Link
			sprintf (szSource,"[AddItem(%s,\"%s\")]",szDest,
				srLinks[iFileNr].cszName);

			progman_execute (szSource);
		}

	}

	DestroyWindow (hProgress);

#ifndef __WIN32__
	FreeProcInstance (fpProc);
#endif


	return DLG_NEXT;
}

void execute_after_install (void)
{
	ffblk ff;

	if (glblExecuteAfterInstall == FALSE)
		return;

	char szBuf [MAX_PATH];

	// Create filename
	strcpy (szBuf,glszInstallPath);
	add_slash (szBuf);
	strcat (szBuf,srFiles[stiExecuteIndex].cszTargetName);


	if (!findfirst (szBuf,&ff,0))
	{
		strcpy (szBuf,glszInstallPath);
		add_slash (szBuf);
		strcat (szBuf,ff.ff_name);
		WinExec (szBuf,SW_SHOWNORMAL);
	}


}
