// ***************************************
//       Datei- Hilfsfunktionen
// ***************************************
//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************
//			filefunc.cpp
// ***************************************
#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.H>
#include <filefunc.h>
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include <ctype.h>
#include <io.h>
#include <install.rh>
#include <lzexpand.h>
#include "buffers.h"
#include <sys\stat.h>

#ifndef __WIN32__
	#define EVAL_CMD HIWORD(lParam)
#else
	#define EVAL_CMD HIWORD(wParam)
#endif


char far *remove_ending_slash (char far *cszPath)
{
	int i = lstrlen (cszPath) -1;

	if (cszPath[i] == '\\')
		cszPath[i] = '\0';

	return cszPath;
}

// Liefert TRUE, wenn Pfad existiert
int path_exist (const char *cszPath)
{
	if (lstrlen (cszPath) <= 3) { 	// Nur Laufwerk-Angabe vorhanden
#ifdef __MSDOS__
		if (GetDriveType (toupper(*cszPath)-'A') == 0)
#else
		if (GetDriveType ((LPCTSTR)cszPath) == 0)
#endif
			return FALSE;
		else
			return TRUE;
	}

	TBuffer szBuf (cszPath);

	if (access (remove_ending_slash (szBuf),0) == 0)
		return TRUE;
	else
		return FALSE;
}

BOOL create_path (const char *cszPath)
{
	ffblk ff;
	char *c,flag=0;

	TBuffer bfPath (strlen (cszPath)+2);
	strcpy (bfPath,cszPath);

	add_slash (bfPath);
	for (c=strchr (bfPath,'\\')+1;*c != 0;c++) {
		if (*c == '\\') {
			*c = '\0';
			if ((findfirst (bfPath,&ff,FA_DIREC))!=0)
				if (mkdir (bfPath))
					return 0;
			*c = '\\';
				flag = 1;
		}
	}
	if (flag == 0 && *(c-2) != ':')
		if (findfirst (bfPath,&ff,FA_DIREC) != 0)
			return FALSE;
	return TRUE;
}


char far *add_slash (char far *szName)
{
	unsigned i;

	i = lstrlen (szName);

	if (i == 1)			// nur Laufwerksbuchstabe
		lstrcat (szName,":\\");
	else if (szName [i-1] != '\\')
		lstrcat (szName,"\\");

	return szName;
}

void update_dlg (HWND hWnd,char const *cszFile)
{
	HWND hList = GetDlgItem (hWnd,DLG_2);
	char szFile [MAX_PATH];

	strcpy (szFile,cszFile);


	add_slash (szFile);


	SendDlgItemMessage (hWnd,DLG_1,WM_SETTEXT,0,(long)szFile);

	int i = (int)SendMessage (hList,LB_GETCURSEL,0,0L);
	SendMessage (hList,LB_RESETCONTENT,0,0L);
	SendMessage (hList,LB_DIR,	DDL_DRIVES	,(long)szFile);

   strcat (szFile,"*.*");
	SendMessage (hList,LB_DIR,DDL_EXCLUSIVE | DDL_DIRECTORY,(long)szFile);

	SendMessage (hList,LB_SETCURSEL,i,0L);

	SendDlgItemMessage (hWnd,DLG_3,WM_SETTEXT,0,(long)"");
}


BOOL CALLBACK SearchPathDialogProc(
	 HWND  hWnd,	// handle of dialog box
	 UINT  uMsg,	// message
	 WPARAM  wParam,	// first message parameter
	 LPARAM  lParam 	// second message parameter
	)
{
	static char far *szPath;

	switch (uMsg)
	{
		case WM_INITDIALOG :
			szPath = (char far*)lParam;
			update_dlg (hWnd,szPath);
			return 1;

		case WM_COMMAND :
			switch (LOWORD (wParam))
			{
				case IDCANCEL :
					EndDialog (hWnd,IDCANCEL);
					break;
				case IDOK :
					EndDialog (hWnd,IDOK);
					break;
				case DLG_1 :
					if (EVAL_CMD == EN_KILLFOCUS)
					{
						char szBuf [MAX_PATH];
						SendDlgItemMessage (hWnd,DLG_1,WM_GETTEXT,MAX_PATH,(long)szBuf);
						if (path_exist (szBuf) == TRUE)
						{
							strcpy (szPath,szBuf);
							update_dlg (hWnd,szPath);
						}
						else
						{
							MessageBox (hWnd,"Fehler:","Der Pfad ist ungltig.",MB_ICONHAND | MB_OK);
							// restore old value:
							SendDlgItemMessage (hWnd,DLG_1,WM_SETTEXT,0,(long)szBuf);
						}
					}
					break;
				case DLG_2 :
					if (EVAL_CMD == LBN_DBLCLK)
					{
						HWND hList = GetDlgItem (hWnd,DLG_2);

						int iSel = (int)SendMessage (hList,LB_GETCURSEL,0,0L);

						char szBuf [MAX_PATH];

						if (iSel == CB_ERR)
							break;

						if (SendMessage (hList,LB_GETTEXT,iSel,(long)szBuf) == CB_ERR)
							break;

						szBuf[strlen (szBuf)-1] = '\0';

						if (szBuf[1] == '.' && szBuf[2] == '.' && szBuf[3] == '\0') // path back
						{
							// remove last path info
							remove_ending_slash (szPath);
							char *c = strrchr (szPath,'\\');
							if (c)
							{
								*(c+1) = '\0';
							}
						}
						else if (szBuf[1] == '-')		// New Directory
						{
							chdir (szPath);
							setdisk (toupper (szBuf[2]) - 'A');
							getcwd (szPath,MAX_PATH);
						}
						else
						{
							add_slash (szPath);
							strcat (szPath,szBuf+1);
						}
						update_dlg (hWnd,szPath);
					}
					break;
				case DLG_4 : // neues Dir anlegen
				{
					char szBuf [MAX_PATH];

					SendDlgItemMessage (hWnd,DLG_3,WM_GETTEXT,MAX_PATH,(long)szBuf);

					if (!szBuf[0])
						break;

					add_slash (szPath);
					#ifdef __WIN32__
						strcat (szPath,"\"");
					#endif
					strcat (szPath,szBuf);

					#ifdef __WIN32__
						strcat (szPath,"\"");
					#endif

					create_path (szPath);
					update_dlg (hWnd,szPath);
					break;
				}
			}
			break;
	}

	return 0;
}

int path_dialog (HWND hParent,char *szBuf,HINSTANCE hInstance)
{
	int iErg;
#ifndef __WIN32__
	FARPROC fpProc = MakeProcInstance ((FARPROC)SearchPathDialogProc,hInstance);
#else
	FARPROC fpProc = (FARPROC)SearchPathDialogProc;
#endif


	if (path_exist (szBuf) == FALSE)
		 GetWindowsDirectory (szBuf,MAX_PATH);

	iErg = DialogBoxParam (hInstance,MAKEINTRESOURCE (Path_DLG),hParent,
			(DLGPROC)fpProc,(long)szBuf);

#ifndef __WIN32__
	FreeProcInstance (fpProc);
#endif

	return iErg;
}

BOOL is_dest_newer (const char *cszDest,const char *cszSource)
{
	struct stat stSource;
	struct stat stDest;

	if (stat (cszDest,&stDest))
		return FALSE;   // File dont exists

	stat (cszSource,&stSource);

	if (stSource.st_atime < stDest.st_atime)
		return TRUE;

	return FALSE;
}


BOOL copy_file (const char *cszDest,const char *cszSource)
{

	OFSTRUCT ofSource,ofDest;

	ofSource.cBytes = ofDest.cBytes = sizeof (OFSTRUCT);

	int iSource = LZOpenFile (cszSource,&ofSource,OF_READ);

	if (iSource < 0)
		return FALSE;

	int iDest = LZOpenFile (cszDest,&ofDest,OF_CREATE);

	if (iDest == HFILE_ERROR )
	{
		LZClose (iSource);
		return FALSE;
	}

	LZCopy (iSource,iDest);

	LZClose (iSource);
	LZClose (iDest);

	return TRUE;
}

