// ***************************************
//       Die Bibel fr Windows 3.1 & 95
// ***************************************
//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************
//   Bibeltext- Small-Viewer
// ***************************************
//   Gehe-zu- Dialog
// ***************************************
//   goto.cpp
// ***************************************
#include "bibel.h"


static void UpdateNavPart (TNavigator* pNav,HWND hWnd)
{

   ComboBox_ResetContent (hWnd);

	TBibelTextData *pBibel = (TBibelTextData*)pNav -> text_data ();

	DWORD i,iMax = pBibel -> part_count ();

	for (i=0;i<iMax;i++)
   	ComboBox_InsertString (hWnd,-1,pBibel -> part_name (i));

	// select
   ComboBox_SetCurSel (hWnd,pNav -> part ());

}

static void UpdateNavBook (TNavigator* pNav,HWND hWnd)
{
  	ComboBox_ResetContent (hWnd);

	TBibelTextData *pBibel = (TBibelTextData*)pNav -> text_data ();

	DWORD dwPart  = pNav -> absolute_part ();
	DWORD i,iMax = pBibel -> book_count (dwPart);

	for (i=0;i<iMax;i++)
   	ComboBox_InsertString (hWnd,-1,pBibel -> book_name (dwPart,i));

	// select
	ComboBox_SetCurSel (hWnd,pNav -> book ());

}

static void UpdateNavChapter (TNavigator* pNav,HWND hWnd)
{
	char szBuf [40];
	ComboBox_ResetContent (hWnd);
	TBibelTextData *pBibel = (TBibelTextData*)pNav -> text_data ();

	unsigned u,uMax = (unsigned)pBibel -> chapter_count (pNav -> part(),pNav -> book());

	for (u=1;u<=uMax;u++)
	{
		itoa (u,szBuf,10);
		ComboBox_InsertString (hWnd,-1,szBuf);
	}

	// select
   ComboBox_SetCurSel (hWnd,pNav -> chapter ());
}

static void UpdateNavVers (TNavigator* pNav,HWND hWnd)
{
	char szBuf [40];
	ComboBox_ResetContent (hWnd);
	TBibelTextData *pBibel = (TBibelTextData*)pNav -> text_data ();

	unsigned u,uMax = (unsigned) pBibel -> vers_count (pNav -> part (),pNav -> book (),
				pNav -> chapter());

	for (u=1;u<=uMax;u++)
	{
		itoa (u,szBuf,10);
      ComboBox_InsertString (hWnd,-1,szBuf);
	}

	// select
   ComboBox_SetCurSel (hWnd,pNav -> vers ());
}

struct SRGotoParam
{
	TNavigator far *pNav;
	const char far *cszCaption;
};

static TNavigator far *st_pNav;

static void OnCommand (HWND hWnd, int iId, HWND hWndCtl, UINT uCodeNotify)
{
   switch (iId)
   {
      case IDOK :
         EndDialog (hWnd,TRUE);
         break;
      case IDCANCEL :
         EndDialog (hWnd,FALSE);
         break;
      case IDHELP :
         MessageBox (hWnd,"Comes later...","Help",MB_OK);
         break;
      case DLG_5 : // Vorschau
         UpdateText (hMainWin,st_pNav);
         break;
      case DLG_1 :
         if (uCodeNotify == CBN_SELCHANGE)
         {
//						unsigned sel = (unsigned)SendDlgItemMessage (hWnd,DLG_1,CB_GETCURSEL,0,0);
            unsigned sel = ComboBox_GetCurSel (hWndCtl);

            st_pNav -> set_part (sel);
            UpdateNavPart (st_pNav,hWndCtl);
            UpdateNavBook (st_pNav,GetDlgItem (hWnd,DLG_2));
            UpdateNavChapter (st_pNav,GetDlgItem (hWnd,DLG_3));
            UpdateNavVers (st_pNav,GetDlgItem (hWnd,DLG_4));

         }
         break;
      case DLG_2 :
         if (uCodeNotify == CBN_SELCHANGE)
         {
//						unsigned sel = (unsigned)SendDlgItemMessage (hWnd,DLG_2,CB_GETCURSEL,0,0);
            unsigned sel = ComboBox_GetCurSel (hWndCtl);
            st_pNav -> set_book (sel);
            UpdateNavBook (st_pNav,hWndCtl);
            UpdateNavChapter (st_pNav,GetDlgItem (hWnd,DLG_3));
            UpdateNavVers (st_pNav,GetDlgItem (hWnd,DLG_4));

         }
         break;
      case DLG_3 :
         if (uCodeNotify == CBN_SELCHANGE)
         {
            //unsigned sel = (unsigned)SendDlgItemMessage (hWnd,DLG_3,CB_GETCURSEL,0,0);
            unsigned sel = ComboBox_GetCurSel (hWndCtl);

            st_pNav -> set_chapter (sel);
            UpdateNavChapter (st_pNav,hWndCtl);
            UpdateNavVers (st_pNav,GetDlgItem (hWnd,DLG_4));

         }
         break;
      case DLG_4 :
         if (uCodeNotify == CBN_SELCHANGE)
         {
            unsigned sel = ComboBox_GetCurSel (hWndCtl);
//						unsigned sel = (unsigned)SendDlgItemMessage (hWnd,DLG_4,CB_GETCURSEL,0,0);
            st_pNav -> set_vers (sel);
            UpdateNavVers (st_pNav,hWndCtl);

         }
         break;
   }
}



BOOL CALLBACK GotoDialogProc(
	 HWND  hWnd,	// handle of dialog box
	 UINT  uMsg,	// message
	 WPARAM  wParam,	// first message parameter
	 LPARAM  lParam 	// second message parameter
	)
{

	switch (uMsg)
	{
		case WM_INITDIALOG :
		{
			SRGotoParam *pParam = (SRGotoParam far *)lParam;
			st_pNav = pParam -> pNav;

			UpdateNavPart (st_pNav,GetDlgItem (hWnd,DLG_1));
			UpdateNavBook (st_pNav,GetDlgItem (hWnd,DLG_2));
			UpdateNavChapter (st_pNav,GetDlgItem (hWnd,DLG_3));
			UpdateNavVers (st_pNav,GetDlgItem (hWnd,DLG_4));
			return 1;
		}
		case WM_COMMAND :
      	HANDLE_WM_COMMAND (hWnd,wParam,lParam,OnCommand);
			break;
	}
	return 0;
}

BOOL goto_dialog (HWND hParent,TNavigator far *pNav,const char far *cszCaption)
{
	SRGotoParam oParam;
	BOOL blErg;

#ifndef __WIN32__
	FARPROC fpProc = MakeProcInstance ((FARPROC)GotoDialogProc,glhInstance);
#else
	FARPROC fpProc = (FARPROC)GotoDialogProc;
#endif

	TNavigator oTempNav (*pNav);
	oParam.cszCaption = cszCaption;
	oParam.pNav = &oTempNav;

	blErg =DialogBoxParam (glhInstance,MAKEINTRESOURCE (Goto_DLG),hParent,(DLGPROC)fpProc,
			(long)&oParam);

	if (blErg == TRUE)
		pNav -> set_pos (&oTempNav);

#ifndef __WIN32__
	FreeProcInstance (fpProc);
#endif

	return blErg;

}


