// ***************************************
//       Die Bibel fr Windows 3.1 & 95
// ***************************************
//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************
//   Installer
// ***************************************
//   Dialoge
// ***************************************
//   instdlg.cpp
// ***************************************
#include <install.h>

#ifndef __WIN32__
	#define EVAL_CMD HIWORD(lParam)
#else
	#define EVAL_CMD HIWORD(wParam)
#endif

void InitDialog (HWND hWnd,int iResId)
{
	switch (iResId)
	{
		case Start_DLG :
			SendDlgItemMessage (hWnd,DLG_1,WM_SETTEXT,0,(long)glszCopyright);
			SendMessage (hWnd,WM_SETTEXT,0,(long)glszText);
			break;
		case Param_DLG :
			SendDlgItemMessage (hWnd,DLG_2,WM_SETTEXT,0,(long)glszInstallPath);
			SendDlgItemMessage (hWnd,DLG_4,BM_SETCHECK,glblShouldCreateLink,0L);
			break;
		case End_DLG :
			SendDlgItemMessage (hWnd,DLG_5,BM_SETCHECK,glblExecuteAfterInstall,0L);
			break;
	}

}

void StoreDialog (HWND hWnd,int iResId)
{

	switch (iResId)
	{
		case Start_DLG :
			break;

		case Param_DLG :
			SendDlgItemMessage (hWnd,DLG_2,WM_GETTEXT,MAX_PATH,(long)&glszInstallPath);
			glblShouldCreateLink = (BOOL)SendDlgItemMessage (hWnd,DLG_4,BM_GETCHECK,0,0L);
			break;
		case End_DLG :
			glblExecuteAfterInstall = (BOOL)SendDlgItemMessage (hWnd,DLG_5,
						BM_GETCHECK,0,0L);
			break;
	}
}


BOOL CALLBACK InstallDialogProc(
	 HWND  hWnd,	// handle of dialog box
	 UINT  uMsg,	// message
	 WPARAM  wParam,	// first message parameter
	 LPARAM  lParam 	// second message parameter
	)
{
	static int stiResId;

	switch (uMsg)
	{
		case WM_INITDIALOG :
		{
			stiResId = (int)lParam;

			center_window (hWnd);


			InitDialog (hWnd,stiResId);
			return 1;
		}

		case WM_COMMAND :
			switch (LOWORD (wParam))
			{
				case DLG_NEXT :
				case DLG_BACK :
				case IDCANCEL :
				case DLG_READY :
					StoreDialog (hWnd,stiResId);
					EndDialog (hWnd,LOWORD (wParam));
					break;
				case DLG_BREAK :
					EndDialog (hWnd,DLG_BREAK);
					break;
				case DLG_3 : // Installationspfad
					{
						char szBuf [MAX_PATH];

						SendDlgItemMessage (hWnd,DLG_2,WM_GETTEXT,MAX_PATH,(long)szBuf);
						if (path_dialog (hWnd,szBuf,glhInstance) == TRUE)
							SendDlgItemMessage (hWnd,DLG_2,WM_SETTEXT,0,(long)szBuf);
					}
					break;

			}
			break;
	}

	return 0;
}



// Deklaration von Methoden
int CallDialog (HWND hParent,int iRes)
{
	int iErg;
#ifndef __WIN32__
	FARPROC fpProc = MakeProcInstance ((FARPROC)InstallDialogProc,glhInstance);
#else
	FARPROC fpProc = (FARPROC)InstallDialogProc;
#endif

	iErg = DialogBoxParam (glhInstance,MAKEINTRESOURCE (iRes),hParent,
			(DLGPROC)fpProc,(long)iRes);

#ifndef __WIN32__
	FreeProcInstance (fpProc);
#endif

	return iErg;
}


void center_window (HWND hWnd)
{
	WINDOWPLACEMENT oPlacement;
	unsigned xScreen,yScreen;
	unsigned uWidth,uHeight;

	// Dialog in Bildschirmmitte positionieren

	// Position und Gre ermitteln
	oPlacement.length = sizeof (oPlacement);
	GetWindowPlacement (hWnd,&oPlacement);

	xScreen = GetSystemMetrics (SM_CXSCREEN);
	yScreen = GetSystemMetrics (SM_CYSCREEN);
	uWidth  = oPlacement.rcNormalPosition.right - oPlacement.rcNormalPosition.left;
	uHeight = oPlacement.rcNormalPosition.bottom - oPlacement.rcNormalPosition.top;

	MoveWindow (hWnd,(xScreen - uWidth)/2,
						  (yScreen - uHeight)/2,
						  uWidth,
						  uHeight,
						  TRUE);


}
