// ***************************************
//       Die Bibel fr Windows 3.1 & 95
// ***************************************
//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************
//   Installer
// ***************************************
//   Mainwindow
// ***************************************
//   instmain.cpp
// ***************************************

#include <install.h>

#define MAINWINNAME "InstallFreeWareBibel"

// Definition von Variable frs Hauptfenster
static const char cszCaption [] = "Die Freeware Bibel";
static const char cszIniFile [] = "Install.ini";


// Definition von Installationsparameter:
char glszInstallPath[MAX_PATH];
BOOL glblShouldCreateLink;
char glszCopyright [BUFSIZE];
char glszText [BUFSIZE];
char glszModuleName[MAX_PATH];	// Name of this executable
char glszModulePath[MAX_PATH]; // Source Path of installation
BOOL glblExecuteAfterInstall;



// Definition allgemeiner Variable
HINSTANCE glhInstance;

//---------------------------------------------------
// Dialog chain
//---------------------------------------------------
// when this value stands in the dialog chain,
// the DoInstall() method is called
#define DOINSTALL -1

static int iaDialogs[] =
{
	Start_DLG,
	Param_DLG,
	DOINSTALL,
	End_DLG,
	NULL
};

static int iAktDialog=0;
static HWND hMainWin=0;
static HWND hDDEWin=0;
static BOOL blTimeOut;

//---------------------------------------------------
//  End of dialog chain definitions
//---------------------------------------------------


LRESULT CALLBACK MainWinProc (HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	static HBITMAP hLogo;

	switch (uMsg) {
		case WM_TIMER :
			switch (wParam)
			{
				case 1:  // Timeouttimer
					KillTimer (hWnd,1);
					blTimeOut = TRUE;
					break;
			}
			break;
		case WM_DDE_ACK :
			hDDEWin = (HWND)wParam;
			break;
		case WM_CREATE :
			hMainWin = hWnd;
			// load logo
			hLogo = LoadBitmap (glhInstance,MAKEINTRESOURCE(InstLogo_BMP));
			break;
		case WM_DESTROY : // Beenden
			PostQuitMessage (0);
			DeleteObject (hLogo);
			return 0;
		case WM_PAINT :
		{
			PAINTSTRUCT oPaintStr;
			HFONT hFont;
			LOGFONT oFont;
			HDC hDC;
			hDC = BeginPaint (hWnd,&oPaintStr); // Zeichnen einleiten

			memset (&oFont,0,sizeof (LOGFONT));
			oFont.lfItalic = TRUE;
			oFont.lfCharSet = ANSI_CHARSET;
			oFont.lfWeight = FW_BOLD;
			oFont.lfHeight = 50;
			strcpy (oFont.lfFaceName,"Times New Roman");

			hFont = CreateFontIndirect (&oFont); // Schriftart erzeugen
			SelectObject (hDC,hFont); // Schriftart auswhlen
			SetBkMode (hDC,TRANSPARENT);	// Schreibmode auf Transparent setzen
			SetTextColor (hDC,RGB(255,255,255)); // Schriftfarbe setzen
			TextOut (hDC,20,20,cszCaption,strlen (cszCaption));
			DeleteObject (hFont);

			// print logo
			HDC hMemDC = CreateCompatibleDC (hDC);
			SelectObject (hMemDC,hLogo);

			BITMAP bm;
			GetObject (hLogo,sizeof (bm),(LPSTR)&bm);

			RECT rClient;
			GetClientRect (hWnd,&rClient);

			BitBlt (hDC,rClient.right-20-bm.bmWidth,20,bm.bmWidth,bm.bmHeight,hMemDC,0,0,SRCCOPY);
			DeleteDC (hMemDC);

			EndPaint (hWnd,&oPaintStr);

			return 0;
		}
		case WM_COMMAND :
			switch (LOWORD(wParam))
			{
				case MSG_CHAIN :
					switch (iaDialogs[iAktDialog])
					{
						case NULL :
							// und tsch...
							PostQuitMessage (0);
							return 0;
						case DOINSTALL :
							if (DoInstall (hWnd) == DLG_BREAK)
							{
								PostQuitMessage (0);
								return 0;
							}
							iAktDialog++;
							break;
						default :
							switch (CallDialog (hWnd,iaDialogs[iAktDialog]))
							{
								case DLG_NEXT :
									iAktDialog++;
									break;
								case DLG_BACK :
									iAktDialog--;
									break;
								case IDCANCEL : // Abbruch vom Benutzer
									if (MessageBox (hWnd,"Sind Sie sicher, da Sie die Installation abbrechen mchten?",
												"Abbruch",MB_YESNO | MB_ICONHAND)
										== IDYES)
									{
										PostQuitMessage (0);
										return 0;
									}
									break;
								case DLG_BREAK : // Unbedingter Abbruch
									PostQuitMessage (0);
									return 0;
								case DLG_READY :
									execute_after_install ();
									PostQuitMessage (0);
									return 0;
							}
							break;
					}
					// und weiter...
					PostMessage (hWnd,WM_COMMAND,MSG_CHAIN,0);
					return 0;
			}
			break;


	}
	return DefWindowProc (hWnd,uMsg,wParam,lParam);
}


int PASCAL WinMain (HINSTANCE hInstance,HINSTANCE /*hPrevInstance*/,LPSTR /*szCmdLine*/,int /*iCmdShow*/)
{
	WNDCLASS wnd;
	MSG msg;
	LOGBRUSH logBackBrush = { BS_SOLID,RGB (0,128,128),NULL };
	char szBuf[MAX_PATH];


	// Set global Data
	glhInstance = hInstance;

	// Set Install-parameter predefines

	glblShouldCreateLink = TRUE;
 	glblExecuteAfterInstall = TRUE;
	GetProfileString ("DieBibel","Pfad","c:\\Bibel",glszInstallPath,MAX_PATH);

	GetModuleFileName	(glhInstance,glszModuleName,MAX_PATH);
	strcpy (glszModulePath,glszModuleName);

	char *c = strrchr (glszModulePath,'\\');
	if (c)
		*(c+1) = '\0';

	strcpy (szBuf,glszModulePath);
	strcat (szBuf,cszIniFile);

	// get info about the text to install
	GetPrivateProfileString ("Translation","Text","Fehler !!",glszText,BUFSIZE,szBuf);
	GetPrivateProfileString ("Translation","Copyright","Die Datei Install.ini fehlt oder ist fehlerhaft!",glszCopyright,BUFSIZE,szBuf);

	// Hintergrund-init
	wnd.cbClsExtra = 0;
	wnd.cbWndExtra = 0;
	wnd.hbrBackground = CreateBrushIndirect (&logBackBrush);
	wnd.hCursor = LoadCursor (NULL,IDC_ARROW);
	wnd.hIcon = LoadIcon (hInstance,MAKEINTRESOURCE(Install_ICO));
	wnd.hInstance = hInstance;
	wnd.lpfnWndProc = MainWinProc;
	wnd.lpszClassName = MAINWINNAME;
	wnd.lpszMenuName = NULL;
	wnd.style = NULL;

	RegisterClass (&wnd);

	HWND hMainWin = CreateWindow (MAINWINNAME,
									"",
									WS_MAXIMIZE | WS_VISIBLE | WS_POPUP,
									0,
									0,
									0,
									0,
									NULL,
									NULL,
									hInstance,
									NULL);

	ShowWindow (hMainWin,SW_SHOWMAXIMIZED);
  	UpdateWindow (hMainWin);

	// 1. INstallationsphase einleiten
	SendMessage (hMainWin,WM_COMMAND,MSG_CHAIN,NULL);

	while (GetMessage (&msg,0,0,0)) {
		TranslateMessage (&msg);
		DispatchMessage (&msg);
	}

	// Brush freigeben:
	DeleteObject (wnd.hbrBackground);

	// Filehelp wieder freigeben

	return msg.wParam;

}


BOOL progman_execute (const char far* cszCmd)
{
	ATOM atApp = GlobalAddAtom ("ProgMan");

	if (!atApp)
		return FALSE;

	ATOM atTopic = GlobalAddAtom ("Progman");
	MSG msg;

	if (!atTopic)
	{
		GlobalDeleteAtom (atApp);
		return FALSE;
	}

	hDDEWin = 0;

	SendMessage ((HWND)-1,WM_DDE_INITIATE,(WPARAM)hMainWin,MAKELONG (atApp,atTopic));
	blTimeOut = FALSE;

	SetTimer (hMainWin,1,10000,0L);

	// wait for acknowledge
	while (blTimeOut == FALSE && !hDDEWin && GetMessage (&msg,0,0,0))
	{
		TranslateMessage (&msg);
		DispatchMessage (&msg);
	}

	GlobalDeleteAtom (atApp);
	GlobalDeleteAtom (atTopic);

	if (blTimeOut == TRUE)
		return FALSE;


	// Send command
	HGLOBAL hCmd = GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT | GMEM_DDESHARE,
		strlen (cszCmd)+1);

	if (hCmd == NULL)
		return FALSE;

	char far *c = (char far*)GlobalLock (hCmd);

	if (!c)
	{
		GlobalFree (hCmd);
		return FALSE;
	}

	strcpy (c,cszCmd);

	GlobalUnlock (hCmd);

	PostMessage (hDDEWin,WM_DDE_EXECUTE,(WPARAM)hMainWin,(LPARAM) MAKELONG (0,hCmd));

	// und tsch..

	PostMessage (hDDEWin,WM_DDE_TERMINATE,(WPARAM)hMainWin,0L);
	hDDEWin=0;

	SetActiveWindow (hMainWin);

	return TRUE;
}
