// ***************************************
//       Die Bibel fr Windows 3.1 & 95
// ***************************************
//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************
//   Hauptfenster (16,32Bit)
// ***************************************
//   MainWin.cpp
// ***************************************
#include <bibel.h>
#include <bibel.rh>


// externe Variable:
HINSTANCE glhInstance;
//char glszModulPath [MAX_PATH];
//SRBibeln glBibeln; // Struktur mit Verweise auf alle Bibeln
TBibelList far *glpBibelList=NULL;  // Objekt mit allen Bibeln

TNavigator far *pNavigator =  NULL;
TBibelTextData far *pBibelData = NULL;
TNavigator far **pNavList=NULL; // pointer to list of Navigator elements
HWND hMainWin=0;



int PASCAL WinMain (HINSTANCE hInstance,HINSTANCE hPrevInstance,
								LPSTR /*szCmdParam*/,int iCmdShow)
{
	if (hPrevInstance)
	{
		MessageBox (NULL,"Es kann immer nur eine Instanz der Bibel geffnet sein.","Fehler:",MB_OK | MB_ICONHAND);
		return -1; 
	}


	MSG msg;
	WNDCLASS wnd;


	glhInstance = hInstance;
	// Bibel liste erzeugen:
	glpBibelList = new TBibelList (hInstance);

	if (!glpBibelList)
		throw new EMiscError ("Cant create Bibellist in WinMain()");

	if (glpBibelList -> count () == 0)
		throw new EMiscError ("Es ist keine Bibel installiert");

	pNavList = new TNavigator*[glpBibelList -> count ()];
	if (!pNavList)
		throw new EMiscError ("Cant init Bible");

	int i,iMax = glpBibelList -> count ();
	for (i=0;i<iMax;i++)
	{
		pNavList [i] = new TNavigator ((TBibelTextData*)glpBibelList -> data (i));
		if (!pNavList[i])
			throw new EMiscError ("Cant init Bible");
	}

	// Hauptfenster aufbauen:
	wnd.cbClsExtra = 0;
	wnd.cbWndExtra = 0;
	wnd.hbrBackground =HBRUSH (GetStockObject (LTGRAY_BRUSH ));
	wnd.hCursor = LoadCursor (NULL,IDC_ARROW);
	wnd.hIcon = LoadIcon (hInstance,MAKEINTRESOURCE(Bibel_ICO));
	wnd.hInstance = hInstance;
	wnd.lpfnWndProc = MainWndProc;
	wnd.lpszClassName = MAINWINCLASS;
	wnd.lpszMenuName = MAKEINTRESOURCE(MainMenu);
	wnd.style = CS_HREDRAW | CS_VREDRAW;

	RegisterClass (&wnd);



	hMainWin = CreateWindow (MAINWINCLASS,
								"Die Bibel",
								WS_OVERLAPPEDWINDOW | WS_VSCROLL | 4L,
		//						WS_BORDER | WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_VSCROLL,
								(GetSystemMetrics (SM_CXSCREEN) - MAINWIDTH)/2,
								(GetSystemMetrics (SM_CYSCREEN) - MAINHEIGHT)/2,
								MAINWIDTH,
								MAINHEIGHT,
								NULL, // Parent
								NULL, // Menu
								hInstance, // Instanz
								NULL);  // Parameter

	ShowWindow (hMainWin,iCmdShow); // Anzeigen
	UpdateWindow(hMainWin);

	// MessageLoop:
	while (GetMessage (&msg,0,0,0)) {
		TranslateMessage (&msg);
		DispatchMessage (&msg);
	}

	// free allocated Memory
	iMax = glpBibelList -> count ();
	for (i=0;i<iMax;i++)
		delete pNavList [i];

	delete [] pNavList;
	delete glpBibelList;

	return msg.wParam;
}

// ***************************************
// Exceptions:
// ***************************************
EMemError::EMemError (const char *cszName)
{
//	strcpy (m_szBuf,cszName);
	MessageBox (0,cszName,"Fehler bei Speicherreservierung:",MB_ICONHAND | MB_OK);
}

EMiscError::EMiscError (const char *cszErr)
{
//	strcpy (m_szBuf,cszErr);
	MessageBox (0,cszErr,"Allgemeiner Fehler:",MB_ICONHAND | MB_OK);
}


