// ***************************************
//       Die Bibel fr Windows 3.1 & 95
// ***************************************
//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************
//   Bibeltext- Datenveraltung
//    fr 16- und 32 Bit
// ***************************************
//   Implementierung class TNavigator
//     fr 16 und 32Bit
// ***************************************
//   Navigat.cpp
// ***************************************
#include "bibdll.h"

#ifdef __DLL__
	#define _NAVIGATOR_IMPEX FAR _export
#endif


#include "navigat.h"
#include "bibtext.h"
#include "bibelist.h"


// ***************************************
//  Hilfsklassen und Methoden
// ***************************************

int eval_index (DWORD _huge *pdwList,DWORD dwSize,DWORD dwSearch)
{
	int u;

	for (u=0;u <= dwSize;u++)
	{
		if (pdwList [u] > dwSearch)
		{
			if (u == 0)
			{
#ifdef _EXCEPT_
				char szBuf [200];
				sprintf (szBuf,"Index error: dwSearch (%X) is to small in eval_index()"
						,(unsigned)dwSearch);
#endif
				EXCEPT (szBuf,0);
			}
			return  u-1;
		}
	}


#ifdef _EXCEPT_
	char szBuf [200];
	sprintf (szBuf,"Index (%X) not found, dwSize = %X in eval_index()",
		(unsigned)dwSearch,(unsigned)dwSize);
#endif

	EXCEPT (szBuf,0);
//	throw new ENavigatorError (szBuf);
}

BOOL add_text (char far *szBuffer,int& iBufSize,const char far *cszAdd)
{
	int iLen = strlen (cszAdd);
	if (iLen >= iBufSize)
		return FALSE;

	strcat (szBuffer,cszAdd);
	iBufSize -= iLen;

	return TRUE;
}

// ***************************************
//  Klasse: TNavigator
// ***************************************

BOOL _DLLCALL TNavigator::set_part (int uPart) // Setzen der Abschnittsnummer
{

	DWORD dwCount,dwIndex;


	if (uPart >= m_pBibel -> part_count())
		return FALSE;

	m_pBibel -> lock ();

	m_uPart = uPart;

	// check, if m_uBook is valid:

	// calc count of books in this part:
	dwIndex = m_pBibel -> part_index (m_uPart);
	dwCount = m_pBibel -> part_index (m_uPart+1) - dwIndex;

	if (m_uBook >= dwCount)
		m_uBook = (int) dwCount-1;

	m_dwAbsBook = dwIndex + m_uBook;

	// check, if m_uChapter is valid
	dwIndex=	m_pBibel -> book_index (m_dwAbsBook);
	dwCount =	m_pBibel -> book_index (m_dwAbsBook +1) - dwIndex;

	if (m_uChapter >= dwCount)
		m_uChapter = (int) dwCount -1;

	m_dwAbsChapter = dwIndex + m_uChapter;

	// check, if m_uVers is valid:
	dwIndex = m_pBibel -> chapter_index (m_dwAbsChapter);
	dwCount = m_pBibel -> chapter_index (m_dwAbsChapter +1) - dwIndex;

	if (m_uVers >= dwCount)
		m_uVers = (int) dwCount-1;

	m_dwAbsVers = dwIndex + m_uVers;

	m_pBibel -> unlock ();

	return TRUE;

}

BOOL _DLLCALL TNavigator::set_book (int uBook) //Setzen der Buchnummer relative zum Abschnitt
{
	m_pBibel -> lock ();

	DWORD dwIndex,dwCount;


	// calc count of books in this part:
	dwIndex = m_pBibel -> part_index (m_uPart);
	dwCount = m_pBibel -> part_index (m_uPart+1) - dwIndex;

	if (uBook >= dwCount)
	{
		m_pBibel -> unlock ();
		return FALSE;
	}

	m_uBook = uBook;

	m_dwAbsBook = dwIndex + m_uBook;

	// check, if m_uChapter is valid
	dwIndex=	m_pBibel -> book_index (m_dwAbsBook);
	dwCount =	m_pBibel -> book_index (m_dwAbsBook +1) - dwIndex;

	if (m_uChapter >= dwCount)
		m_uChapter = (int)  dwCount -1;

	m_dwAbsChapter = dwIndex + m_uChapter;

	// check, if m_uVers is valid:
	dwIndex = m_pBibel -> chapter_index (m_dwAbsChapter);
	dwCount = m_pBibel -> chapter_index (m_dwAbsChapter +1) - dwIndex;

	if (m_uVers >= dwCount)
		m_uVers =(int)  dwCount-1;

	m_dwAbsVers = dwIndex + m_uVers;

	m_pBibel -> unlock ();

	return TRUE;

}

BOOL _DLLCALL TNavigator::set_chapter (int uChapter) // Setzen der Kapitelnummer relativ zum Buch
{
	m_pBibel -> lock ();

	DWORD dwIndex,dwCount;

	// check, if m_uChapter is valid
	dwIndex = m_pBibel -> book_index (m_dwAbsBook);
	dwCount = m_pBibel -> book_index (m_dwAbsBook +1) - dwIndex;

	if (uChapter >= dwCount)
	{
		m_pBibel -> unlock ();
		return FALSE;
	}

	m_uChapter = uChapter;
	m_dwAbsChapter = dwIndex + m_uChapter;

	// check, if m_uVers is valid:
	dwIndex = m_pBibel -> chapter_index (m_dwAbsChapter);
	dwCount = m_pBibel -> chapter_index (m_dwAbsChapter +1) - dwIndex;

	if (m_uVers >= dwCount)
		m_uVers =(int)  dwCount-1;

	m_dwAbsVers = dwIndex + m_uVers;

	m_pBibel -> unlock ();
	return TRUE;

}

// Daten-Setzen-Funktionen, liefern TRUE, wenn Setzen erfolgreich, sonst FALSE
BOOL _DLLCALL TNavigator::set_vers (int uVers) // Setzen der Versnummer relativ zum Kapitel
{
	m_pBibel -> lock ();

	DWORD dwIndex,dwCount;

	// check, if m_uVers is valid:
	dwIndex = m_pBibel -> chapter_index (m_dwAbsChapter);
	dwCount = m_pBibel -> chapter_index (m_dwAbsChapter +1) - dwIndex;

	if (uVers >= dwCount)
	{
		m_pBibel -> unlock ();
		return FALSE;
	}

	m_uVers = uVers;

	m_dwAbsVers = dwIndex + m_uVers;

	m_pBibel -> unlock ();

	return TRUE;

}

BOOL _DLLCALL TNavigator::set_absolute_book (DWORD dwBook)
{
	m_pBibel -> lock ();

	DWORD dwIndex,dwCount;

	if (dwBook >= m_pBibel -> absolute_book_count())
	{
		m_pBibel -> unlock ();
		return FALSE;
	}

	m_dwAbsBook = dwBook;
	// evaluate part of this book:
	m_uPart = eval_index (m_pBibel -> m_lkdwaPartIndexList,
					m_pBibel -> absolute_part_count(),dwBook);

	m_uBook = (int)(m_dwAbsBook - m_pBibel ->	part_index (m_uPart));

// check, if m_uChapter is valid
	dwIndex = m_pBibel -> book_index (m_dwAbsBook);
	dwCount = m_pBibel -> book_index (m_dwAbsBook +1) - dwIndex;

	if (m_uChapter >= dwCount)
		m_uChapter = (int)dwCount -1;

	m_dwAbsChapter = dwIndex + m_uChapter;

	// check, if m_uVers is valid:
	dwIndex = m_pBibel -> chapter_index (m_dwAbsChapter);
	dwCount = m_pBibel -> chapter_index (m_dwAbsChapter +1) - dwIndex;

	if (m_uVers >= dwCount)
		m_uVers = (int)dwCount-1;

	m_dwAbsVers = dwIndex + m_uVers;

	m_pBibel -> unlock ();
	return TRUE;

}


BOOL _DLLCALL TNavigator::set_absolute_chapter (DWORD dwChapter)
{
	m_pBibel -> lock ();

	DWORD dwIndex,dwCount;

	// check, if dwChapter is valid
	if (dwChapter >= m_pBibel -> absolute_chapter_count ())
	{
		m_pBibel -> unlock ();
		return FALSE;
	}

	m_dwAbsChapter = dwChapter;

	// evalute book:
	m_dwAbsBook = eval_index (m_pBibel -> m_lkdwaBookIndexList,
								m_pBibel -> absolute_book_count (),
								m_dwAbsChapter);
	m_uChapter = (int) (m_dwAbsChapter - m_pBibel -> book_index (m_dwAbsBook));

	m_uPart = eval_index (m_pBibel -> m_lkdwaPartIndexList,
					m_pBibel -> absolute_part_count(),m_dwAbsBook);

	m_uBook = (int)(m_dwAbsBook - m_pBibel -> part_index (m_uPart));


	// check, if m_uVers is valid:
	dwIndex = m_pBibel -> chapter_index (m_dwAbsChapter);
	dwCount = m_pBibel -> chapter_index (m_dwAbsChapter +1) - dwIndex;

	if (m_uVers >= dwCount)
		m_uVers = (int)dwCount-1;

	m_dwAbsVers = dwIndex + m_uVers;

	m_pBibel -> unlock ();

	return TRUE;

}

BOOL _DLLCALL TNavigator::set_absolute_vers (DWORD dwVers)
{

	m_pBibel -> lock ();

	if (dwVers >= m_pBibel -> absolute_vers_count ())
	{
		m_pBibel -> unlock ();
		return FALSE;
	}

	m_dwAbsVers = dwVers;

	m_dwAbsChapter = eval_index ( m_pBibel -> m_lkdwaChapterIndexList,
											m_pBibel -> absolute_chapter_count (),
											m_dwAbsVers);
	m_uVers = (int) (m_dwAbsVers - m_pBibel -> chapter_index (m_dwAbsChapter));

	// evalute book:
	m_dwAbsBook = eval_index (m_pBibel ->m_lkdwaBookIndexList,
								m_pBibel -> absolute_book_count (),
								m_dwAbsChapter);

	m_uChapter = (int)(m_dwAbsChapter - m_pBibel -> book_index (m_dwAbsBook));

	m_uPart = eval_index (m_pBibel -> m_lkdwaPartIndexList,
					m_pBibel -> absolute_part_count(),m_dwAbsBook);

	m_uBook = (int)(m_dwAbsBook - m_pBibel -> part_index (m_uPart));

	m_pBibel -> unlock ();

	return TRUE;
}

// Additionsoperator, schaltet zum nchsten Vers
BOOL _DLLCALL TNavigator::next (void)
{
	m_pBibel -> lock ();

	int uVers = m_uVers;
	int uChapter = m_uChapter;
	int uBook = m_uBook;
	int uPart = m_uPart;
	BOOL blChanged = FALSE;

	uVers++;

	if (uVers >= (m_pBibel -> chapter_index (m_dwAbsChapter+1) -
			m_pBibel -> chapter_index (m_dwAbsChapter))) {
		uVers = 0;
		uChapter++;

		if (uChapter >= (m_pBibel -> book_index (m_dwAbsBook+1) -
				m_pBibel -> book_index (m_dwAbsBook))) {
			uChapter = 0;
			uBook++;

			if (uBook >= (m_pBibel -> part_index (m_uPart+1) -
					m_pBibel -> part_index (m_uPart))) {
				uBook = 0;
				uPart++;

				if (uPart >= m_pBibel -> absolute_part_count ()) {
					m_pBibel -> unlock ();
					return FALSE;
				}
			}
		}
	}

	// update absoulte valued:
	if (m_uPart != uPart)
	{
		m_uPart = uPart;
		blChanged = TRUE;
	}

	if (m_uBook != uBook || blChanged == TRUE)
	{
		m_uBook = uBook;
		m_dwAbsBook = m_pBibel -> part_index (m_uPart) + m_uBook;
		blChanged = TRUE;
	}

	if (m_uChapter != uChapter || blChanged == TRUE)
	{
		m_uChapter = uChapter;
		m_dwAbsChapter = m_pBibel -> book_index (m_dwAbsBook) + m_uChapter;
		blChanged = TRUE;
	}

	if (m_uVers != uVers || blChanged == TRUE)
	{
		m_uVers = uVers;
		m_dwAbsVers = m_pBibel -> chapter_index (m_dwAbsChapter) + m_uVers;
	}

	m_pBibel -> unlock ();
	return TRUE;

}

BOOL _DLLCALL TNavigator::prev (void)
{
	m_pBibel -> lock ();

	long lVers = m_uVers;
	long lChapter = m_uChapter;
	long lBook = m_uBook;
	long lPart = m_uPart;
	BOOL blChanged = FALSE;

	lVers--;
	if (lVers < 0) {
		lChapter --;
		if (lChapter < 0)
		{
			lBook--;
			if (lBook < 0)
			{
				lPart--;
				if (lPart < 0)
				{
					m_pBibel -> unlock ();
					return FALSE;
				}

				lBook = 	m_pBibel -> book_count (lPart) - 1;
			}
			lChapter = 	m_pBibel -> chapter_count (lPart,lBook) -1;

		}
		lVers = 	m_pBibel -> vers_count (lPart,lBook,lChapter) -1;
	}

	// update absoulte valued:
	if (m_uPart != lPart)
	{
		m_uPart = (int) lPart;
		blChanged = TRUE;
	}

	if (m_uBook != lBook || blChanged == TRUE)
	{
		m_uBook = (int)lBook;
		m_dwAbsBook = m_pBibel -> part_index (m_uPart) + m_uBook;
		blChanged = TRUE;
	}

	if (m_uChapter != lChapter || blChanged == TRUE)
	{
		m_uChapter = (int)lChapter;
		m_dwAbsChapter = m_pBibel -> book_index (m_dwAbsBook) + m_uChapter;
		blChanged = TRUE;
	}

	if (m_uVers != lVers || blChanged == TRUE)
	{
		m_uVers = (int)lVers;
		m_dwAbsVers = m_pBibel -> chapter_index (m_dwAbsChapter) + m_uVers;
	}

	m_pBibel -> unlock ();
	return TRUE;

}

//****++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

void _DLLCALL TNavigator::set_pos (const INavigator* far pNav)
{
	if (!pNav)
		EXCEPT ("pNav is NULL in TNaviogator::set_pos",);


	m_pBibel -> lock ();

	DWORD dwCount,dwIndex;

	m_uPart = ((TNavigator*)pNav) -> m_uPart;

	// check, part is if vald
	dwCount = m_pBibel -> absolute_part_count ();
	if (m_uPart >= dwCount)
		m_uPart = (int) dwCount-1;

	// check is book is valid
	m_uBook = ((TNavigator*)pNav) -> m_uBook;

	dwIndex = m_pBibel -> part_index (m_uPart);
	dwCount = m_pBibel -> part_index (m_uPart+1) - dwIndex;

	if (m_uBook >= dwCount)
		m_uBook = (int) dwCount-1;

	m_dwAbsBook = dwIndex + m_uBook;

	// check is chapter is valid
	m_uChapter = ((TNavigator*)pNav) -> m_uChapter;

	dwIndex = m_pBibel -> book_index (m_dwAbsBook);
	dwCount = m_pBibel -> book_index (m_dwAbsBook+1) - dwIndex;

	if (m_uChapter >= dwCount)
		m_uChapter = (int) dwCount-1;

	m_dwAbsChapter = dwIndex + m_uChapter;


		// check is vers is valid
	m_uVers = ((TNavigator*)pNav) -> m_uVers;

	dwIndex = m_pBibel -> chapter_index (m_dwAbsChapter);
	dwCount = m_pBibel -> chapter_index (m_dwAbsChapter+1) - dwIndex;

	if (m_uVers >= dwCount)
		m_uVers = (int) dwCount-1;

	m_dwAbsVers = dwIndex + m_uVers;

	m_pBibel -> unlock ();

}


BOOL _DLLCALL TNavigator::position_name (char far *szBuffer,int iBufferSize)
{
	char szBuf [200];

	if (!iBufferSize)
		return FALSE;

	m_pBibel -> lock ();

	iBufferSize--;
	szBuffer[0] = '\0';

	if (add_text (szBuffer,iBufferSize,m_pBibel -> part_name (m_uPart)) == FALSE)
		return FALSE;

	if (add_text (szBuffer,iBufferSize,": ") == FALSE)
		return FALSE;

	if (add_text (szBuffer,iBufferSize,m_pBibel -> book_name(m_uPart,
			m_uBook)) == FALSE)
				return FALSE;

	szBuf [0] = ' ';
	itoa (m_uChapter+1,szBuf+1,10);
	strcat (szBuf,",");
	if (add_text (szBuffer,iBufferSize,szBuf) == FALSE)
			return FALSE;

	itoa (m_uVers +1,szBuf,10);

	if (add_text (szBuffer,iBufferSize,szBuf) == FALSE)
		return FALSE;


	m_pBibel -> unlock ();

	return TRUE;
}

IBibelTextData* _DLLCALL TNavigator::text_data (void)
{
	return  m_pBibel;
}


TNavigator::TNavigator (const TNavigator& oNav)
{
	// Alle Daten einfach nur kopieren:
	memcpy (this,&oNav,sizeof (TNavigator));
}

TNavigator::TNavigator (TBibelTextData *pBibel)
{
	m_uPart = NULL;
	m_uBook = NULL;
	m_uChapter = NULL;
	m_uVers = NULL;

	m_dwAbsBook = NULL;
	m_dwAbsChapter = NULL;
	m_dwAbsVers = NULL;

	m_pBibel = pBibel;

	if (!m_pBibel)
		EXCEPT ("Navigator ohne gltigen Bibel-Bezug in constructor of TNavigator",);
}



