// ***************************************
//       Die Bibel fr Windows 3.1 & 95
// ***************************************
//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************
//   Bibeltext- Small-Viewer
// ***************************************
//   Informations- Dialog
// ***************************************
//   info.cpp
// ***************************************
#include <bibel.h>

BOOL CALLBACK InfoDialogProc(
	 HWND  hWnd,	// handle of dialog box
    UINT  uMsg,	// message
    WPARAM  wParam,	// first message parameter
    LPARAM  //lParam 	// second message parameter
   )
{
	switch (uMsg)
   {
   	case WM_INITDIALOG :
		{
			char szBuf [256];

			// Name
			SendDlgItemMessage (hWnd,DLG_1,WM_SETTEXT,0,(long)pBibelData -> name ());
			// Copyright
			SendDlgItemMessage (hWnd,DLG_2,WM_SETTEXT,0,(long)pBibelData -> copyright ());

			// Anzahl Abschnitte
			ultoa (pBibelData -> absolute_part_count (),szBuf,10);
			SendDlgItemMessage (hWnd,DLG_3,WM_SETTEXT,0,(long)szBuf);
			// Anzahl Bcher
			ultoa (pBibelData -> absolute_book_count (),szBuf,10);
			SendDlgItemMessage (hWnd,DLG_4,WM_SETTEXT,0,(long)szBuf);
			// Anzahl Kapitel
         ultoa (pBibelData -> absolute_chapter_count (),szBuf,10);
         SendDlgItemMessage (hWnd,DLG_5,WM_SETTEXT,0,(long)szBuf);
         // Anzahl Verse
         ultoa (pBibelData -> absolute_vers_count (),szBuf,10);
         SendDlgItemMessage (hWnd,DLG_6,WM_SETTEXT,0,(long)szBuf);
         // Anzahl Wrter
         ultoa (pBibelData -> absolute_word_count (),szBuf,10);
         SendDlgItemMessage (hWnd,DLG_7,WM_SETTEXT,0,(long)szBuf);
			// Spicherbedarf Festplatte
			ultoa (pBibelData -> file_size (),szBuf,10);
			strcat (szBuf," Byte");
			SendDlgItemMessage (hWnd,DLG_8,WM_SETTEXT,0,(long)szBuf);
			// Speicherbedarf Hauptspeicher
			ultoa (pBibelData -> mem_size (),szBuf,10);
			strcat (szBuf," Byte");
			SendDlgItemMessage (hWnd,DLG_9,WM_SETTEXT,0,(long)szBuf);

			return 1;
		}
		case WM_COMMAND :
			switch (LOWORD(wParam))
			{
				case IDOK :
					EndDialog (hWnd,TRUE);
					return 1;
				case IDHELP :
					MessageBox (hWnd,"Comes later...","Help",MB_OK);
					return 1;
			}
			break;

	}

	return 0;
}


void info_dialog (HWND hParent)
{

#ifndef __WIN32__
	FARPROC fpProc = MakeProcInstance ((FARPROC)InfoDialogProc,glhInstance);
#else
	FARPROC fpProc = (FARPROC)InfoDialogProc;
#endif

	DialogBox (glhInstance,MAKEINTRESOURCE (BibelInfo_DLG),hParent,(DLGPROC)fpProc);

#ifndef __WIN32__
	FreeProcInstance (fpProc);
#endif
}


