// ***************************************
//       Die Bibel fr Windows 3.1 & 95
// ***************************************
	//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************
//   Hauptfenster (16Bit)
// ***************************************
//   MainW16.cpp
// ***************************************
#include <bibel.h>

#define WM_BIB_SCROLL	1001

static HHOOK hHook;
static HWND hPart,hList,hText;
int iLineCount = 0;
int iLineLength = 0;
int iLastVisibleChar = 0;
int iSecondVersOffset=0;
int iLastSecondVersOffset=0;
static int iAktBibel = 0; // Aktuelle Bibelbersetzung

void OnVScroll(HWND hWnd, HWND /*hWndCtl*/, UINT uCode, int iPos)
{
   switch (uCode) {
      case SB_TOP :
         pNavigator -> set_absolute_vers (0);
         UpdateText (hWnd,pNavigator);
         break;
      case SB_BOTTOM :
         pNavigator -> set_absolute_vers (pBibelData -> absolute_vers_count ()-1);
         UpdateText (hWnd,pNavigator);
         break;
      case SB_LINEUP :
         pNavigator -> prev ();
         UpdateText (hWnd,pNavigator);
         break;
      case SB_THUMBPOSITION :
      case SB_THUMBTRACK	:
         pNavigator -> set_absolute_vers (iPos);
         UpdateText (hWnd,pNavigator);
         break;
      case SB_LINEDOWN :
         pNavigator -> next ();
         UpdateText (hWnd,pNavigator);
         break;
      case SB_PAGEUP :
         pNavigator -> set_absolute_chapter (pNavigator -> absolute_chapter ()-1);
         UpdateText (hWnd,pNavigator);
         break;
      case SB_PAGEDOWN :
         pNavigator -> set_absolute_chapter (pNavigator -> absolute_chapter ()+1);
         UpdateText (hWnd,pNavigator);
         break;
   }
}


void OnCommand(HWND hWnd, int iId, HWND /*hWndCtl*/, UINT uCodeNotify)
{
   // Andere bersetzung?
   if (iId >= CM_TranslationFirst && iId <= CM_TranslationLast) {
      int iTrans = iId - CM_TranslationFirst;

      if (iAktBibel != iTrans) {	// bersetzung tauschen:
         // Alte bersetzung schlieen
         CloseBibel (hWnd,iAktBibel);

         // Neue ffnen:
         iAktBibel = iTrans;
         OpenBibel (hWnd,iAktBibel);
      }
      return;

   }
   switch (iId) {
      case CM_CopyClip :
         copyclip_dialog (hWnd,pNavigator);
         // repair previews:
         UpdateText (hMainWin,pNavigator);
         return;
      case CM_HELPINDEX :
         MessageBox (hWnd,"Comes later..","Hilfe -> Inhalt",MB_OK);
         return ;
      case CM_HELPABOUT :
         about_dialog (hWnd);
         return ;
      case CM_GoingTo :
         goto_dialog (hWnd,pNavigator,"Gehe zu...");

         UpdateText (hMainWin,pNavigator);
         return ;

      case CM_InfoTranslation :
         info_dialog (hWnd);
         return ;
      case ID_Part :
         if (uCodeNotify == CBN_SELCHANGE) {
            // Neue Abschnittsnummer ermitteln
            pNavigator -> set_part (ComboBox_GetCurSel (hPart));
//						pNavigator -> set_part ((int)SendDlgItemMessage (hWnd,ID_Part,CB_GETCURSEL,0,0));

            pNavigator -> set_book (0);
            pNavigator -> set_chapter (0);
            pNavigator -> set_vers (0);

            // Buchliste updaten:
            UpdateBookList (hWnd,pNavigator);
         }
         break;
      case ID_List :
         if (uCodeNotify == LBN_SELCHANGE) {
            // Neues Buch ermitteln:
            pNavigator -> set_book (ListBox_GetCurSel (hList));
//						pNavigator -> set_book ((int)SendDlgItemMessage (hWnd,ID_List,LB_GETCURSEL,0,0));
            pNavigator -> set_chapter (0);
            pNavigator -> set_vers (0);

            UpdateText (hWnd,pNavigator);
         }
         break;
      case ID_TextControl :
         if (uCodeNotify == EN_UPDATE)
            break;
         break;
      case CM_EXIT :
         SendMessage (hWnd,WM_DESTROY,0,NULL);
         return;

   }
}

LRESULT CALLBACK GetMsgProc(int iCode,WPARAM wParam,LPARAM lParam)
{
	MSG *pMsg = (MSG*)lParam;

	if (pMsg -> hwnd == hText)
	{
		switch (pMsg -> message)
		{
			case WM_KEYDOWN :
				switch (pMsg -> wParam)
				{
					case VK_DOWN :
					{
//						DWORD dwSel = SendMessage (hText,EM_GETSEL,0,0L);
						DWORD dwSel = Edit_GetSel (hText);

						WORD wEnd = HIWORD (dwSel);
						int iLine = (int)SendMessage (hText,EM_LINEFROMCHAR,wEnd,0L);

						if (iLine == (iLineCount-1))
						{
							PostMessage (GetParent (hText),WM_BIB_SCROLL,SB_LINEDOWN,dwSel);
							PostMessage (pMsg -> hwnd,pMsg -> message,pMsg -> wParam,pMsg -> lParam);
							pMsg -> message = 0;
						}
						break;
					}
					case VK_UP :
					{
						DWORD dwSel = Edit_GetSel(hText);
						WORD wStart = LOWORD (dwSel);

						int iLine = Edit_LineFromChar(hText,wStart);

						if (iLine == 0)
						{
							PostMessage (GetParent (hText),WM_BIB_SCROLL,SB_LINEUP,dwSel);
							PostMessage (pMsg -> hwnd,pMsg -> message,pMsg -> wParam,pMsg -> lParam);
							pMsg -> message = 0;
						}
						break;
					}
					case VK_PRIOR :
					{
						DWORD dwSel = Edit_GetSel(hText);
						PostMessage (GetParent (hText),WM_BIB_SCROLL,SB_LINEUP,dwSel);
						pMsg -> message = 0;
						break;
					}
					case VK_NEXT :
					{
  						DWORD dwSel = Edit_GetSel(hText);
						PostMessage (GetParent (hText),WM_BIB_SCROLL,SB_LINEDOWN,dwSel);
						pMsg -> message = 0;

						break;
					}
					case VK_LEFT :
					{
  						DWORD dwSel = Edit_GetSel(hText);
						WORD wStart = LOWORD (dwSel);
						if (wStart == 0)
						{
							PostMessage (GetParent (hText),WM_BIB_SCROLL,SB_LINEUP,dwSel);
							PostMessage (pMsg -> hwnd,pMsg -> message,pMsg -> wParam,pMsg -> lParam);
							pMsg -> message = 0;
						}
						break;
					}
					case VK_RIGHT :
					{
						DWORD dwSel = Edit_GetSel(hText);
						WORD wEnd = HIWORD (dwSel);
						if (wEnd >= iLastVisibleChar)
						{
							PostMessage (GetParent (hText),WM_BIB_SCROLL,SB_LINEDOWN,dwSel);
							PostMessage (pMsg -> hwnd,pMsg -> message,pMsg -> wParam,pMsg -> lParam);
							pMsg -> message = 0;
						}
						break;
					}
				}
				break;
		}
	}

	return CallNextHookEx (hHook,iCode,wParam,lParam);
}


// Hauptfenster-Callback
LRESULT CALLBACK MainWndProc (HWND hWnd,UINT iMsg,WPARAM wParam,LPARAM lParam)
{
#ifndef __WIN32__
	static FARPROC hHookProc=0;
#endif

	switch (iMsg) {
		case WM_CREATE :
		{
			int i;
			HMENU hMenu;

			// bersetzungen ins Men eintragen.
			hMenu = GetMenu (hWnd); // Men ermitteln

			// Fr jede bersetzung einen Menpunkt einfgen:
			int iMax = glpBibelList -> count ();
			for (i=0; i < iMax;i++) {
				TBibelTextData *pData = (TBibelTextData*)glpBibelList -> data (i);
				InsertMenu (hMenu,CM_Dummy,MF_BYCOMMAND,CM_TranslationFirst + i,pData -> name ());
			}
			// Dummy lschen
			RemoveMenu (hMenu,CM_Dummy,MF_BYCOMMAND);
			// Bildschirm- Dialogelemente aufbauen


			// Combobox fr Bibelteil aufbauen:
			hPart = CreateWindowEx (0,
											"COMBOBOX",
											"", // Headline
											CBS_DROPDOWNLIST | WS_CHILD | WS_VISIBLE | WS_TABSTOP,
											0,0,
											0,0,
											hWnd,
											(HMENU) ID_Part,
											glhInstance,
											NULL);

			// Kapitelliste aufbauen
			hList = CreateWindowEx (0,
					  						"LISTBOX",
											"", // Headline
											WS_VISIBLE | WS_CHILD | WS_BORDER | /*LBS_HASSTRINGS | */WS_VSCROLL | LBS_NOTIFY	,
											0,0,
											0,0,
											hWnd,
											(HMENU) ID_List,
											glhInstance,
											NULL);
			// Textcontrol erzeugen
			hText = CreateWindowEx (0,
											"EDIT",   // Klasse
											"", // Headline
											WS_VISIBLE | WS_CHILD | WS_BORDER | ES_MULTILINE | ES_READONLY,
											0,0,
											0,0,
											hWnd,
											(HMENU) ID_TextControl,
											glhInstance,
											NULL);

#ifndef __WIN32__
			hHookProc = MakeProcInstance ((FARPROC)GetMsgProc,glhInstance);
			hHook = SetWindowsHookEx (WH_GETMESSAGE,(HOOKPROC)hHookProc,glhInstance,
					GetCurrentTask());
#else
			hHook = SetWindowsHookEx (WH_GETMESSAGE,(HOOKPROC)GetMsgProc,glhInstance,
					GetCurrentThreadId());
#endif


			// Datenzugriff ffnen
			OpenBibel (hWnd,iAktBibel);

					//			SetTimer (hWnd,1,100,0);

			return 0;
		}
#ifdef __WIN32__
      case WM_CTLCOLORSTATIC :
      	if ((HWND) lParam == hText)
            return (long)GetStockObject (WHITE_BRUSH);
      	break;
#endif
		case WM_TIMER :
			pNavigator -> next ();
			UpdateText (hWnd,pNavigator);
			break;
		case WM_BIB_SCROLL :
			switch (wParam)
			{
				case SB_LINEUP :
				{
					pNavigator -> prev ();
					UpdateText (hWnd,pNavigator);

					// set cursor
					int wStart = LOWORD (lParam);
					int wEnd   = HIWORD (lParam);
					wStart += iSecondVersOffset;
					wEnd += iSecondVersOffset;

					if (wStart >= iLastVisibleChar)
						wStart = iLastVisibleChar -1;
					if (wEnd >= iLastVisibleChar)
						wEnd = iLastVisibleChar -1;

               Edit_SetSel(GetDlgItem (hWnd,ID_TextControl),wEnd,wStart);
//					SendMessage (hText,EM_SETSEL,0,MAKELPARAM (wEnd,wStart));

					return 0;
				}
				case SB_LINEDOWN :
					pNavigator -> next ();
					UpdateText (hWnd,pNavigator);

					// set cursor
					int wStart = LOWORD (lParam);
					int wEnd 	= HIWORD (lParam);

					wStart -= iLastSecondVersOffset;
					wEnd -= iLastSecondVersOffset;

					if (wStart < 0)
						wStart = 0;
					if (wEnd < 0)
               	wEnd = 0;

					Edit_SetSel(hText,wStart,wEnd);
//					SendMessage (hText,EM_SETSEL,0,MAKELPARAM (wStart,wEnd));

					return 0;
			}
			break;
		case WM_SIZE :
		{
			const int ciBorder = 4;
			int iWidth = LOWORD(lParam);  /* width of client area  */
			int iHeight = HIWORD(lParam); /* height of client area */
			int iMiddle  = iWidth /3;
			int iHalfBorder = (ciBorder+1)/2;
			int iDoubleBorder = ciBorder*2;
			RECT r;

			MoveWindow (hPart,ciBorder,ciBorder,iMiddle-iDoubleBorder,80,TRUE);

			GetWindowRect (hPart,&r);
			ScreenToClient (hWnd,(POINT far*)&r.left);
			ScreenToClient (hWnd,(POINT far*)&r.right);

			MoveWindow (hList,ciBorder,iDoubleBorder + r.bottom,iMiddle -
					iDoubleBorder,iHeight - ciBorder- r.bottom-r.top,TRUE);

			GetWindowRect (hList,&r);
			ScreenToClient (hWnd,(POINT far*)&r.left);
			ScreenToClient (hWnd,(POINT far*)&r.right);

			MoveWindow (hText,iMiddle + iHalfBorder,ciBorder,iMiddle*2-iDoubleBorder,
					r.bottom - ciBorder,TRUE);

			// Calculate new LineCount
			TEXTMETRIC oTM;
			HDC hDC = GetDC (hWnd);
			GetTextMetrics (hDC,&oTM);

         Edit_GetRect (hText,&r);

//			SendMessage (hText,EM_GETRECT,0,(long)&r);
			iLineCount = (r.bottom - r.top) / oTM.tmHeight;
			iLineLength = (r.right - r.left) / oTM.tmAveCharWidth;

			UpdateText (hWnd,pNavigator);
			return 0;
		}
		case WM_VSCROLL :
      	HANDLE_WM_VSCROLL (hWnd,wParam,lParam,OnVScroll);
			break;

		case WM_COMMAND :
      	HANDLE_WM_COMMAND (hWnd,wParam,lParam,OnCommand);
			break;
		case WM_DESTROY :
			CloseBibel (hWnd,iAktBibel);

			UnhookWindowsHookEx (hHook);
#ifndef __WIN32__
			if (hHookProc)
			{
				FreeProcInstance (hHookProc);
				hHookProc = 0;
			}
#endif

			PostQuitMessage (0);
			return 0;
		default :
			return DefWindowProc (hWnd,iMsg,wParam,lParam);
	}
	return 0;
}


