// ***************************************
//   Datei: BibText.CPP
// ***************************************
//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************

#ifndef BIBTEXT_H
#define BIBTEXT_H


#include "bibimp.h"
class TNavigator;


class _BIBELTEXTDATA_IMPEX TBibelTextData
	: public IBibelTextData
{
	private :

#ifdef __WIN32__
		TCriticalSection m_csLock;
#endif

		// Dateizugriff:
		OFSTRUCT m_oFileData;
		HFILE m_hFile;
		DWORD m_dwMemSize;
		int m_uLock; // Sind die Lock-Variable gltig?, alle Vars mit lk im Prefix
		DWORD m_dwLoadOffset; // file offset to load data
		BOOL m_blLoaded;	// are all Datas actual loaded?
		BOOL m_blWasLoaded; 	// was this bibel one times loaded (are the absolute vars
									// initiated ??
      char *m_szFilename;

		// Allgemeine Infos
		DWORD m_dwMiscCount;    			// Anzahl der allgemeinen Eintrge
		DWORD  *m_dwaMiscList; 				// Liste allgemeiner Eintrge, 0: Name der bersetzung 1:Copyright
		HGLOBAL m_hMiscList;					// Speicher der Liste der allg. Eintrge
		HGLOBAL m_hMiscMem;     			// Speicherung der Misc-String
		char _huge *m_szMiscMem;					// Zeiger auf Speicher fr Strings

		// Wortliste
		DWORD m_dwWordCount; 				// Anzahl der Wrter
		DWORD _huge *m_lkdwaWordList;		// Integer Array, Wortliste
		HGLOBAL m_hWordList;    			// Speicher der Wortliste
		HGLOBAL m_hWordMem;					// Speicherung der Wrter-Stings
		char _huge *m_lkszWordMem;			// Zeiger auf Speicher fr Strings

		// Versliste
		DWORD m_dwVersCount;					// Anzahl der Verse
		DWORD _huge *m_lkdwaVersIndexList;		// Integer Array, Versliste
		HGLOBAL m_hVersIndexList;    		// Speicherung der Vers-Liste

		// Kapitelliste
		DWORD m_dwChapterCount;    		// Anzahl der Kapitel
		DWORD _huge *m_lkdwaChapterIndexList;	// Integer-Array der Kapitelliste
		HGLOBAL m_hChapterIndexList; 		// Speicherung der Kapitelliste

		// Buchliste
		DWORD m_dwBookCount;		 			// Anzahl der Bcher
		DWORD _huge *m_lkdwaBookList;	 			// Integer-Array der Buchnamenliste
		HGLOBAL m_hBookList;		 			// Speicherung der Buchnamen
		HGLOBAL m_hBookMem;		 			// Speicher der Buch-Strings
		DWORD _huge *m_lkdwaBookIndexList;	 	// Buch-Index-Liste
		HGLOBAL m_hBookIndexList;			// Speicherung der Book-Index-Liste
		char _huge *m_lkszBookMem;					// Zeiger auf Speicher fr Strings

		// Abschnittliste
		DWORD m_dwPartCount;		 			// Anzahl der Abschnitte
		DWORD _huge *m_lkdwaPartList;		 		// Integer-Array der Abschnitte-Namen-Liste
		HGLOBAL m_hPartList;		 			// Speicher der Abschnittnamenliste
		HGLOBAL m_hPartMem;					// Speicherung der Abschnittenamen
		DWORD  _huge *m_lkdwaPartIndexList;		// Buch-Abschnittliste
		HGLOBAL m_hPartIndexList;        // Speicherung der Abschnitte-INdex-Liste
		char _huge *m_lkszPartMem;					// Zeiger auf Speicher fr Strings


		// Wrterliste
		DWORD m_dwWordsCount;	 // Lnge der Wrterliste in Byte
		DWORD m_lWordsStartPos;   // Startposition der Wrter in der Datei,
										 // Offset fr die Wortliste
		DWORD m_dwFileSize;		// size of bib-file
      DWORD m_dwAbsWordCount; // Anzahl der Wrter


      		// Einlesen einer Liste von Strings aus hFile, die Anzahl wird in iStringCount bertragen,
		// Die Liste selbst wird als char-Array in iaStringList erzeugt. Die Strings liegen im
		// Speicher von hStringList. iaStringList und hStringList werden mit GlobalAlloc erzeugt
		DWORD ReadStringList
				(HFILE hFile,DWORD& dwSringCount,HGLOBAL& hStringList,HGLOBAL& hStringMem);

		// Einlesen einer Liste von Indizes aus hFile mit dwListCount Elementen
		// Die Liste wird in dwaList angelegt. Der Speicher mit GlobalAlloc
		// angefordert.
		DWORD ReadIndexList (HFILE hFile,DWORD dwListCount,HGLOBAL& hList);

		// Alle Pointer auf NULL;
		void ClearPointer (void);

		// Pointer lschen, wenn vorhanden:
		void FreeGlobalPointer (HGLOBAL& hGlobal);

		// Pointer locken
		void LockPointer (HGLOBAL hGlobal,void **pPtr);

		// Pointer unlocken
		void UnlockPointer (HGLOBAL hGlobal,void **pPtr);

		void load (void);  // load datas
		void unload (void); // remove datas from memory

		// throw execption, if not locked or not loaed:
		void check_lock_load (void) const;

      void set_last_index_entry (HGLOBAL hList,DWORD dwLastIndex,DWORD dwLastElement);


	protected :

	public :

		// Konstruktor
		TBibelTextData (const char *cszFileName,DWORD dwFileLen);

		// Destruktor
		virtual ~TBibelTextData ();

		// Globale Daten fr den Zugiff locken
		virtual void _DLLCALL lock (void);

		// Globale Daten freigeben, und so im Speicher verschiebbar machen:
		virtual void _DLLCALL unlock (void);

		// Name der bersetzung abfragen
		virtual const char far* _DLLCALL name (void) const;

		// Copyright abfragen:
		virtual const char far* _DLLCALL copyright (void) const;

		// Zugriffsfunktionen auf Abschnittsdaten:
		virtual DWORD _DLLCALL part_count (void) const // Anzahl der Abschnitte ermitteln
			{	return m_dwPartCount; }

      virtual DWORD _DLLCALL file_size (void) const
      	{ return m_dwFileSize; }

		virtual const char far* _DLLCALL part_name (DWORD dwIndex) const; // Abschnittsname ermitteln

		// Zugriffsfunktionen auf Buchdaten:
		virtual DWORD _DLLCALL book_count (DWORD dwPartNr) const; // Anzahl der Bcher ermitteln
		virtual const char far* _DLLCALL book_name (DWORD dwPartNr,DWORD dwBookNr) const; // Bchername ermitteln

		// Zugriffsfunktionen auf Kapiteldaten:
		virtual DWORD _DLLCALL chapter_count (DWORD dwPartNr,DWORD dwBookNr) const; // Anzahl der Kapitel ermitteln

		// Zugriffsfunktionen auf Versdaten:
		virtual DWORD _DLLCALL vers_count (DWORD dwPartNr,DWORD dwBookNr,DWORD dwChapterNr) const; // Anzahl der Verse ermitteln

				// fill Buffer with Bibel-Text
		virtual BOOL _DLLCALL fill_buffer (DWORD iBufSize,char _huge* szBuffer,const INavigator far *pBegin,DWORD lVersCount);

		virtual DWORD _DLLCALL mem_size (void);
		virtual DWORD _DLLCALL absolute_part_count (void);
		virtual DWORD _DLLCALL absolute_book_count (void);
		virtual DWORD _DLLCALL absolute_chapter_count (void);
		virtual DWORD _DLLCALL absolute_vers_count (void);
      virtual DWORD _DLLCALL absolute_word_count (void);


		virtual DWORD _DLLCALL part_index (DWORD dwIndex) const; // Abchnittsindex einer Abschnittseintragung ermitteln
		virtual DWORD _DLLCALL book_index (DWORD dwIndex) const; // Bcherindex einer Bucheintragung ermitteln

		// Kapitelindex einer Kapiteleintragung ermitteln
		virtual DWORD _DLLCALL chapter_index (DWORD dwIndex) const;

		virtual DWORD _DLLCALL vers_index (DWORD dwIndex) const; // Verseindex einer Verseintragung ermitteln


      friend TNavigator;
};

#endif

