// ***************************************
//	  Datei: Navigat.cpp
// ***************************************
//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************

#ifndef NAVIGAT_H
#define NAVIGAT_H

#include "bibimp.h"

class TBibelTextData;


class _NAVIGATOR_IMPEX TNavigator
	: public INavigator
{
	private :

      DWORD m_dwAbsBook;
      DWORD m_dwAbsChapter;
      DWORD m_dwAbsVers;

      int m_uPart;
      int m_uBook;
      int m_uChapter;
      int m_uVers;

      TBibelTextData *m_pBibel;


		friend TBibelTextData;


	protected :


	public :

		// Konstruktor:
		TNavigator (TBibelTextData far *pBibel);
		TNavigator (const TNavigator& oNav);

		virtual int _DLLCALL part (void) const// Rckgabe der Abschnittsnumme
			{ return m_uPart; }
		virtual int _DLLCALL book (void) const// Rckgabe der Buchnummer
			{ return m_uBook; }
		virtual int _DLLCALL chapter (void) const// Rckgabe der Buchenummer
			{ return m_uChapter; }
		virtual int _DLLCALL vers (void) const// Rckgabe der Versnummer
			{ return m_uVers; }

		// Daten-Setzen-Funktionen, liefern TRUE, wenn Setzen erfolgreich, sonst FALSE
		virtual BOOL _DLLCALL set_part (int uPart); // Setzen der Abschnittsnummer
		virtual BOOL _DLLCALL set_book (int uBook); //Setzen der Buchnummer relative zum Abschnitt
		virtual BOOL _DLLCALL set_chapter (int uChapter); // Setzen der Kapitelnummer relativ zum Buch
		virtual BOOL _DLLCALL set_vers (int uVers); // Setzen der Versnummer relativ zum Kapitel

		virtual BOOL _DLLCALL set_absolute_part (DWORD dwPart)
			{ return set_part ((int) dwPart); }

		virtual BOOL _DLLCALL set_absolute_book (DWORD dwBook);
		virtual BOOL _DLLCALL set_absolute_chapter (DWORD dwChapter);
		virtual BOOL _DLLCALL set_absolute_vers (DWORD dwVers);

		virtual DWORD _DLLCALL absolute_part (void) const
			{ return (DWORD) part (); }
		virtual DWORD _DLLCALL absolute_book (void) const
			{ return m_dwAbsBook; }
		virtual DWORD _DLLCALL absolute_chapter (void) const
			{ return m_dwAbsChapter; }
		virtual DWORD _DLLCALL absolute_vers (void) const
			{ return m_dwAbsVers; }

		virtual BOOL _DLLCALL prev (void); // set navigator to previous vers, ret TRUE, if valid
		virtual BOOL _DLLCALL next (void); // set navigator to next vers, ret TRUE, if valid
		// or false, if we are at the last vers.

		virtual void _DLLCALL set_pos (const INavigator* far pNav);

		virtual BOOL _DLLCALL position_name (char far *szBuffer,int iBufferSize);

      virtual IBibelTextData* _DLLCALL text_data (void);
};

#endif

