// ***************************************
//	  Datei: bibimp.h
// ***************************************
//   (c) 1996/97 by Olaf Panz
//		 Niedere Strae 21
//
//     78050 VS-Villingen
//
//		olaf.panz@t-online.de
//	 http://home.t-online.de/home/olaf.panz
// ***************************************
//  Import-Schnittstelle von bib32.dll
// ***************************************
#ifndef BIIMP_H
#define BIIMP_H

#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#ifdef __DLL__
   #ifndef _BIBELTEXTDATA_IMPEX
   	#define _BIBELTEXTDATA_IMPEX _import
   #endif
#else
	#ifndef _BIBELTEXTDATA_IMPEX
   	#define _BIBELTEXTDATA_IMPEX
   #endif
#endif

class INavigator;

class _BIBELTEXTDATA_IMPEX IBibelTextData
{
	public :
   
		virtual void _DLLCALL lock (void) =0;
		virtual void _DLLCALL unlock (void)=0;

		virtual const char far* _DLLCALL name (void) const=0;
		virtual const char far* _DLLCALL copyright (void) const=0;

		virtual const char far* _DLLCALL part_name (DWORD dwIndex) const=0;
		virtual const char far* _DLLCALL book_name (DWORD dwPartNr,DWORD dwBookNr) const=0;

		virtual DWORD _DLLCALL part_count (void) const=0;
		virtual DWORD _DLLCALL book_count (DWORD dwPartNr) const=0;
		virtual DWORD _DLLCALL chapter_count (DWORD dwPartNr,DWORD dwBookNr) const=0;
		virtual DWORD _DLLCALL vers_count (DWORD dwPartNr,DWORD dwBookNr,DWORD dwChapterNr) const=0;

		virtual DWORD _DLLCALL absolute_part_count (void)=0;
		virtual DWORD _DLLCALL absolute_book_count (void)=0;
		virtual DWORD _DLLCALL absolute_chapter_count (void)=0;
		virtual DWORD _DLLCALL absolute_vers_count (void)=0;
      virtual DWORD _DLLCALL absolute_word_count (void)=0;


		virtual DWORD _DLLCALL part_index (DWORD dwIndex) const=0;
		virtual DWORD _DLLCALL book_index (DWORD dwIndex) const=0;
		virtual DWORD _DLLCALL chapter_index (DWORD dwIndex) const=0;
		virtual DWORD _DLLCALL vers_index (DWORD dwIndex) const=0;

		virtual BOOL _DLLCALL fill_buffer (DWORD iBufSize,char _huge* szBuffer,const INavigator far *pBegin,DWORD lVersCount)=0;

		virtual DWORD _DLLCALL mem_size (void)=0;
      virtual DWORD _DLLCALL file_size (void) const=0;
};


#ifdef __DLL__
   #ifndef _NAVIGATOR_IMPEX
   	#define _NAVIGATOR_IMPEX _import
   #endif
#else
	#ifndef _NAVIGATOR_IMPEX
   	#define _NAVIGATOR_IMPEX
   #endif
#endif

class _NAVIGATOR_IMPEX INavigator
{
	public :

		virtual int _DLLCALL part (void) const=0;
		virtual int _DLLCALL book (void) const=0;
		virtual int _DLLCALL chapter (void) const=0;
		virtual int _DLLCALL vers (void) const=0;

		virtual BOOL _DLLCALL set_part (int uPart)=0;
		virtual BOOL _DLLCALL set_book (int uBook)=0;
		virtual BOOL _DLLCALL set_chapter (int uChapter)=0;
		virtual BOOL _DLLCALL set_vers (int uVers)=0;

  		virtual DWORD _DLLCALL absolute_part (void) const=0;
		virtual DWORD _DLLCALL absolute_book (void) const=0;
		virtual DWORD _DLLCALL absolute_chapter (void) const=0;
		virtual DWORD _DLLCALL absolute_vers (void) const=0;

		virtual BOOL _DLLCALL set_absolute_part (DWORD dwPart)=0;
		virtual BOOL _DLLCALL set_absolute_book (DWORD dwBook)=0;
		virtual BOOL _DLLCALL set_absolute_chapter (DWORD dwChapter)=0;
		virtual BOOL _DLLCALL set_absolute_vers (DWORD dwVers)=0;


		virtual BOOL _DLLCALL prev (void)=0;
		virtual BOOL _DLLCALL next (void)=0;

		virtual void _DLLCALL set_pos (const INavigator* far pNav)=0;
		virtual BOOL _DLLCALL position_name (char far *szBuffer,int iBufferSize)=0;
      virtual IBibelTextData* _DLLCALL text_data (void)=0;
};


#ifdef __DLL__
   #ifndef _BIBLIST_IMPEX
   	#define _BIBLIST_IMPEX _import
   #endif
#else
	#ifndef _BIBLIST_IMPEX
   	#define _BIBLIST_IMPEX
   #endif
#endif

class _BIBLIST_IMPEX IBibelList
{
	public :

      virtual int _DLLCALL count (void) const=0;
      virtual IBibelTextData* _DLLCALL data (unsigned uIndex) const=0;
};

#if defined(__DLL__) && defined(__WIN32__)
extern "C" {

IBibelList* _stdcall _export bibel_list (void);

};
#endif

#endif


