package tools;

import java.io.*;

/**
 * This output stream writes a compressed HTML file.
 *
 * @author Olaf Panz
 * @version 1.0
 */
public class HtmlCompressorOutputStream extends FilterOutputStream
{

    /**
     * First filter: remove new lines.
     *
     * This filter is build as a cascade of methods.
     *
     * @param data The data char/byte to filter
     * @exception IOException Is thrown if a writing error occures.
     */
    public void write(int data) throws IOException
    {
        // First approach: eliminate \r and \n

        if (data != '\r' && data != '\n')
            write2( data);
    }

    /**
     * Second filter: Eliminate double white spaces
     *
     * This filter is build as a cascade of methods.
     *
     * @param data The data char/byte to filter
     * @exception IOException Is thrown if a writing error occures.
     */
    private void write2 (int data) throws IOException
    {
        // check, is character is whitespace:
        boolean isWs = Character.isWhitespace ((char)data);

        if (isWs == false || _isWhitespace == false)
            lastWrite (data);
        _isWhitespace = isWs;
    }

    /**
     * Whitespace flag:
     */
    private boolean _isWhitespace = true;


    /**
     * Last method of the filter chain.
     *
     * Calls the super write method and do statistics.
     *
     * @param data The data char/byte to filter
     * @exception IOException Is thrown if a writing error occures.
     */
    private void lastWrite (int data) throws IOException
    {
        super.write( data);
        _writtenBytes++;
    }


    /**
     * Create a new object with given child stream.
     *
     * @param out The child output stream
     */
    public HtmlCompressorOutputStream (OutputStream out)
    {
        super (out);
    }

    /**
     * Access to the count of written bytes.
     *
     * @return The count of written bytes.
     */
    public long getWrittenBytes ()
    {
        return _writtenBytes;
    }

    /**
     * Count of written bytes.
     */
    private long _writtenBytes = 0;

}
