package de.jbible;

import java.util.*;
import java.io.*;

import de.jbible.core.*;
/**
 * This is the main class of the JBibel.
 *
 * It contains an interfaces for the communication
 * of all facilities. <br>
 * <b>Startup procedure </b><br>
 * <ol>
 * <li>The service manager is created and loads the properties.</li>
 * <li>The main frame is created</li>
 * <li>The services are initialised. The property file contains a
 * section which contains the service classes. These classes are instanziated
 * with the parameterless default costructor. The class must implement the
 * {@link de.jbible.core.Service Service}
 * interface. Then the
 * {@link de.jbible.core.Service#init init} method is called.</li>
 * <ol>
 *
 * For definition of services see
 * {@link de.jbible.core.ServiceManager ServiceManager}
 *
 *
 * @see de.jbible.core.Service
 * @see de.jbible.core.ServiceManager
 */

public class Main
{
    public static void main(String[] args)
    {

        try
        {

            // Redirect stdout and error to log file:
 		   /*	PrintStream ps = new PrintStream (new FileOutputStream ("c:\\jbible.log"));
   	     	System.setErr(ps);
   	     	System.setOut(ps);*/

            // for testing:
            //Locale.setDefault (Locale.CHINESE);
            ServiceManager.start (args);
        }
        catch (Throwable tw)
        {
            System.err.println ("JBible eror:"+tw);
            tw.printStackTrace();
        /*    try
            {
                System.in.read();
            }
            catch (IOException ex) {}*/
        }
    }

    public final static String APP_TITLE = "JBible 0.1 (GPL)";
}
