package de.jbible.bible;

/**
 * Interface with definitions of the biblical books.
 *
 * Each module that referes to biblical books should use this definitions.
 * If you need to add forgotten books, you must do this at the end because
 * these definitions are also uses in the file format.
 * <br>
 * Rules for names: Use the english name of the book, except books beginning
 * with numbers: we write the number behind, so 1Samuel is called "Samuel1".
 * Spaces in names are eliminated, e.G. SongOfSongs.
 * <br>
 * The order here is: New Testament, Aphocryphs, New Testament. This has nothing
 * to do with the order to read or store the bible text.
 */

public interface BibleBooks
{
    /** Debugging.*/
    public static final byte Unknown             = 0;

    /** Old Testament. */
    public static final byte Genesis             = 1;
    public static final byte Exodus              = 2;
    public static final byte Leviticus           = 3;
    public static final byte Numbers             = 4;
    public static final byte Deuteronomy         = 5;
    public static final byte Joshua              = 6;
    public static final byte Judges              = 7;
    public static final byte Ruth                = 8;
    public static final byte Samuel1             = 9;
    public static final byte Samuel2             = 10;
    public static final byte Kings1              = 11;
    public static final byte Kings2              = 12;
    public static final byte Chronicles1         = 13;
    public static final byte Chronicles2         = 14;
    public static final byte Ezra                = 15;
    public static final byte Nehemiah            = 16;
    public static final byte Esther              = 17;
    public static final byte Job                 = 18;
    public static final byte Psalms              = 19;
    public static final byte Proverbs            = 20;
    public static final byte Ecclesiastes        = 21;
    public static final byte SongOfSongs         = 22;
    public static final byte Isaiah              = 23;
    public static final byte Jeremiah            = 24;
    public static final byte Lamentations        = 25;
    public static final byte Ezekiel             = 26;
    public static final byte Daniel              = 27;
    public static final byte Hosea               = 28;
    public static final byte Joel                = 29;
    public static final byte Amos                = 30;
    public static final byte Obadiah             = 31;
    public static final byte Jonah               = 32;
    public static final byte Micah               = 33;
    public static final byte Nahum               = 34;
    public static final byte Habakkuk            = 35;
    public static final byte Zephaniah           = 36;
    public static final byte Haggai              = 37;
    public static final byte Zechariah           = 38;
    public static final byte Malachi             = 39;


    /** New Testament. */
    public static final byte Matthew             = 100;
    public static final byte Mark                = 101;
    public static final byte Luke                = 102;
    public static final byte John                = 103;
    public static final byte Acts                = 104;
    public static final byte Romans              = 105;
    public static final byte Corinthians1        = 106;
    public static final byte Corinthians2        = 107;
    public static final byte Galatians           = 108;
    public static final byte Ephesians           = 109;
    public static final byte Philippians         = 110;
    public static final byte Colossians          = 111;
    public static final byte Thessalonians1      = 112;
    public static final byte Thessalonians2      = 113;
    public static final byte Timothy1            = 114;
    public static final byte Timothy2            = 115;
    public static final byte Titus               = 116;
    public static final byte Philemon            = 117;
    public static final byte Hebrews             = 118;
    public static final byte James               = 119;
    public static final byte Peter1              = 120;
    public static final byte Peter2              = 121;
    public static final byte John1               = 122;
    public static final byte John2               = 123;
    public static final byte John3               = 124;
    public static final byte Jude                = 125;
    public static final byte Revelation          = 126;

    /** Books of Apocrypha. */
    public static final byte Esdra1              = -1;
    public static final byte Esdra2              = -2;
    public static final byte Tobit               = -3;
    public static final byte Judith              = -4;
    public static final byte Wisdom              = -5;
    public static final byte Sirach              = -6;
    public static final byte Baruch              = -7;
    public static final byte Azariah             = -8;
    public static final byte Susanna             = -9;
    public static final byte Bel                 = -10;
    public static final byte Manasses            = -11;
    public static final byte Maccabees1          = -12;
    public static final byte Maccabees2          = -13;
    public static final byte DanielAddOn         = -14;
    public static final byte EstherAddOn         = -15;

    public static final byte OldTestament        = -100;
    public static final byte NewTestament        = -101;
    public static final byte Apocrypha           = -102;

    /** Set of bible parts. */
    public static final byte [] Parts = {
        OldTestament,
        NewTestament,
        Apocrypha,
    };

    /** Names of bible parts.
     * Used for debug only.*/
    public static final String [] PartNames = {
        "OldTestament",
        "NewTestament",
        "Apocrypha",
    };

    /** Books of the old testament. */
    public static final byte [] OldTestamentBooks = {
        Genesis,
        Exodus,
        Leviticus,
        Numbers,
        Deuteronomy,
        Joshua,
        Judges,
        Ruth,
        Samuel1,
        Samuel2,
        Kings1,
        Kings2,
        Chronicles1,
        Chronicles2,
        Ezra,
        Nehemiah,
        Esther,
        Job,
        Psalms,
        Proverbs,
        Ecclesiastes,
        SongOfSongs,
        Isaiah,
        Jeremiah,
        Lamentations,
        Ezekiel,
        Daniel,
        Hosea,
        Joel,
        Amos,
        Obadiah,
        Jonah,
        Micah,
        Nahum,
        Habakkuk,
        Zephaniah,
        Haggai,
        Zechariah,
        Malachi
    };

    /** Names of Books of the old testament.
     * Used for debug only.*/
    public static final String [] OldTestamentBookNames = {
        "Genesis",
        "Exodus",
        "Leviticus",
        "Numbers",
        "Deuteronomy",
        "Joshua",
        "Judges",
        "Ruth",
        "Samuel1",
        "Samuel2",
        "Kings1",
        "Kings2",
        "Chronicles1",
        "Chronicles2",
        "Ezra",
        "Nehemiah",
        "Esther",
        "Job",
        "Psalms",
        "Proverbs",
        "Ecclesiastes",
        "SongOfSongs",
        "Isaiah",
        "Jeremiah",
        "Lamentations",
        "Ezekiel",
        "Daniel",
        "Hosea",
        "Joel",
        "Amos",
        "Obadiah",
        "Jonah",
        "Micah",
        "Nahum",
        "Habakkuk",
        "Zephaniah",
        "Haggai",
        "Zechariah",
        "Malachi",
    };

    /** Books of the new testament. */
    public static final byte [] NewTestamentBooks = {
        Matthew,
        Mark,
        Luke,
        John,
        Acts,
        Romans,
        Corinthians1,
        Corinthians2,
        Galatians,
        Ephesians,
        Philippians,
        Colossians,
        Thessalonians1,
        Thessalonians2,
        Timothy1,
        Timothy2,
        Titus,
        Philemon,
        Hebrews,
        James,
        Peter1,
        Peter2,
        John1,
        John2,
        John3,
        Jude,
        Revelation
    };

    /** Names of Books of the new testament. */
    public static final String [] NewTestamentBookNames = {
        "Matthew",
        "Mark",
        "Luke",
        "John",
        "Acts",
        "Romans",
        "Corinthians1",
        "Corinthians2",
        "Galatians",
        "Ephesians",
        "Philippians",
        "Colossians",
        "Thessalonians1",
        "Thessalonians2",
        "Timothy1",
        "Timothy2",
        "Titus",
        "Philemon",
        "Hebrews",
        "James",
        "Peter1",
        "Peter2",
        "John1",
        "John2",
        "John3",
        "Jude",
        "Revelation"
    };

    /** Set of Apocrypha books. */
    public static final byte [] ApocryphaBooks = {
        Esdra1,
        Esdra2,
        Tobit,
        Judith,
        Wisdom,
        Sirach,
        Baruch,
        Azariah,
        Susanna,
        Bel,
        Manasses,
        Maccabees1,
        Maccabees2,
        DanielAddOn,
        EstherAddOn,
    };

    /** Names of Apocrypha books. */
    public static final String [] ApocryphaBookNames = {
        "Esdra1",
        "Esdra2",
        "Tobit",
        "Judith",
        "Wisdom",
        "Sirach",
        "Baruch",
        "Azariah",
        "Susanna",
        "Bel",
        "Manasses",
        "Maccabees1",
        "Maccabees2",
        "DanielAddOn",
        "EstherAddOn",
    };

    /** Count of all known bible books. */
    public static final int bookCount = OldTestamentBooks.length +
    									NewTestamentBooks.length +
                                        ApocryphaBooks.length;
}
