package de.jbible.bible;

import java.io.*;
import java.util.*;
import java.lang.*;


/**
 * Interface to import bibles.
 *
 * <p>
 * The importing process read word by word. With word I mean here the word of god.
 * Headlines, book name,.. are no word but additional informations.
 * The {link #readWord readWord} Method gets a Map as parameter. All
 * additional parameters must be stored here. The keys are defined in this
 * interface. Note, that there are several data types! A additional information
 * must only set for the first time it occures. This means that the complete
 * position of a word comes from the reading context.</p>
 *
 * <h4>Example</h4>
 * An example with the first twoword in a bible: "In the"<br>
 *
 * readWord () returns "In" <br>
 * The map contains:<br>
 *
 *
 */
public interface BibleImportReader
{

    /**
     * Read the next book.
     *
     * <p>
     * If the value is null, you are behind the last book of
     * the stream.</p>
     *
     * @return The complete book as object tree.
	 * @exception IOException An io exception occures while reading.
     *
     * @see de.jbible.bible.BibleBooks
     */
    public Object readBook () throws IOException;


    /**
     * Finish the reading.
     *
     * @exception IOException An io exception can occure.
     */
    public void close () throws IOException;

    /**
     * Returns the filename of the file after import.
     *
     * This filename has no extension and no path. That means that
     * both will be added.
     *
     * @return The file name.
     */
	public String getFileName ();

    /**
     * Get the copyright notice.
     *
     * @return The copyright string.
     */
	public String getCopyright ();

    /**
     * Get the copyright identifer as defined in
     * {@link de.jbible.tool.bibleimport.Header Header}
     *
     * @return The copyright identifier.
     */
	public int getCopyrightIdentifier ();

    /**
     * Get the original title of the bible translation.
     *
     * @return The original title.
     */
    public String getTitle ();

    /**
     * Return a Java conform language identifier
     * that describe the language of this bible translation.
     *
     * See Java class Local for details.
     *
     * @return The identifer.
     */
	public String getLocale ();
}
