package de.jbible.bible;

/**
 * Utilities to handle bible definitions.
 */

public class Utilities
{
    /**
     * Eval the part identifier for a given book as
     * specified in {@link BibleBooks BibleBooks}
     *
     * @param book A book identifier
     * @return The part of this book, 0 means Unknown.
     */
    public static byte getPartOfBook (byte book)
    {
        if (testPartOfBook (book,BibleBooks.NewTestamentBooks))
            return BibleBooks.NewTestament;
        if (testPartOfBook (book,BibleBooks.OldTestamentBooks))
            return BibleBooks.OldTestament;
        if (testPartOfBook (book,BibleBooks.ApocryphaBooks))
            return BibleBooks.Apocrypha;
        return BibleBooks.Unknown;
    }

    private static boolean testPartOfBook (byte book,byte[]test)
    {
        for (int i=0;i<test.length;i++)
            if (test[i] == book)
                return true;
        return false;
    }

    /** Return the name of a book.
     *
     * Used for debug and error messages only.
     *
     * @param define The define of the book.
     * @return The name of the book as string.
     */
    public static String getBookName (byte def)
    {
    	if (_bookNames == null)
        {
            // Create _names array:
            _bookNames = new String [256];

            addNames (_bookNames,BibleBooks.OldTestamentBookNames,
            	BibleBooks.OldTestamentBooks);
			addNames (_bookNames,BibleBooks.ApocryphaBookNames,
            	BibleBooks.ApocryphaBooks);
            addNames (_bookNames,BibleBooks.NewTestamentBookNames,
            	BibleBooks.NewTestamentBooks);
            addNames (_bookNames,BibleBooks.PartNames,
            	BibleBooks.Parts);
        }

        return _bookNames [def +128];

    }

    /**
     * Add the given names at the corresponding position into
     * the first string array.
     *
     * This method is used to build up the book name index.
     *
     * @param names The name index that should be build.
     * @param books The book list that should be added.
     * @param ident The indices where to put the book names to.
     */
    private static void addNames (String [] names,
    	String[] books,byte[] ident)
    {
    	int i;
        for (i=0;i<books.length;i++)
        {
        	names[ident[i]+128] = books[i];
        }
    }

    /**
     * Part filter for bible book identifier.
     *
     * Filter all book of one selection out
     * of the given array of book identifier
     * and create a new array with all ids.
     *
     * @param arr The source array. This array will not be changed.
     * @param part The part identifier. (OldTestament, NewTestament,
     *		Apocrypha)
     * @return The result array.
     * @see BibleBooks
     */
	public byte[] filterBooksFromPart (byte[] arr,byte part)
    {
    	byte[] result = new byte [arr.length];
        byte[] set;

        switch (part)
        {
        	case BibleBooks.OldTestament :
            	set = BibleBooks.OldTestamentBooks;
                break;
        	case BibleBooks.NewTestament :
            	set = BibleBooks.NewTestamentBooks;
                break;
        	case BibleBooks.Apocrypha :
            	set = BibleBooks.ApocryphaBooks;
                break;
            default :
            	throw new IndexOutOfBoundsException ("Parameter part is invalid");
        }

        int i,j;
        int count=0;
        for (i=0;i<arr.length;i++)
        {
        	for (j=0;j<set.length;j++)
            {
            	if (arr[i] == set [j])
                {
                	result [count++] = arr[i];
                    break;
                }
            }
        }

        // create new result (optimize space)
        byte [] result2 = new byte [count];
        System.arraycopy(result,0,result2,0,result2.length);

        return result2;

    }


    /** Array of book names.
     * Used for debug and error messages only.
     */
	private static String []_bookNames=null;

}










