package de.jbible.bible;
/**
 * This interface provide all informations to describe a vers.
 *
 */

public interface Vers
{
    /**
     * Access to the vers number.
     *
     * This value is relative to the chapter.
     *
     * @return The number of this vers.
     */
    public byte getVers ();

    /**
     * Access to the chapter of the actual vers.
     *
     * This value is relative to the book.
     *
     * @return The chapter number
     */
    public byte getChapter ();

    /**
     * Access to the book.
     *
     * @return The book identifier from
     * (@link BibleBooks BibleBooks)
     */
    public byte getBook ();

    /**
     * Access to the part number. (New Testament, Old Testament)
     *
     * @return The part number, as denfined in
     *  (@link BibleBooks BibleBooks)
     */
    public byte getPart ();

}
