package de.jbible.bible;
/**
 * This class contains a link to a vers from a word.
 *
 * The word is specified by the word index. The objects of this
 * type are not mutable.
 */

public class VersLink extends VersLocation
{
    /*
     * Create a new object.
     *
     * @param part The part index.
     * @param book The book index. (absulute)
     * @param chapter The chapter index (relative to the book)
     * @param vers The vers index (relative to the chaper)
     *
     * @see BibleBooks
     */
    public VersLink(byte book,byte chapter,byte vers,byte wordIndex)
    {
        super (book,chapter,vers);
        _wordIndex = wordIndex;
    }

    /**
     * Access to the word index.
     *
     * @return The index to the word the link comes from.
     */
    public int getWordIndex ()
    {
        return _wordIndex;
    }

    /** The index of the word from that this vers come from. */
    private byte _wordIndex;
}