package de.jbible.bible;

/**
 * This class contains a vers description.
 *
 * The instances of this class are not mutable.
 *
 */
public class VersLocation implements Vers
{
    /*
     * Create a new object.
     *
     * @param book The book index. (absulute)
     * @param chapter The chapter index (relative to the book)
     * @param vers The vers index (relative to the chaper)
     *
     * @see BibleBooks
     */
    public VersLocation (byte book,byte chapter,byte vers)
    {
        _book = book;
        _chapter = chapter;
        _vers = vers;
    }

    /** Debug output. */
    public String toString ()
    {
        return "VerLocation (B:"+Utilities.getBookName(_book)
        	+" "+_chapter+","+_vers+")";
    }

    /** No default constructor . */
    private VersLocation () {}

    /**
     * Access to the vers number.
     *
     * This value is relative to the chapter.
     *
     * @return The number of this vers.
     */
    public byte getVers ()
    {
        return _vers;
    }


    /**
     * Access to the chapter of the actual vers.
     * This value is relative to the book.
     *
     * @return The chapter number
     */
    public byte getChapter ()
    {
        return _chapter;
    }

    /**
     * Access to the book.
     *
     * @return The book identifier from
     * (@link BibleBooks BibleBooks)
     */
    public byte getBook ()
    {
        return _book;
    }

    /**
     * Access to the part number. (New Testament, Old Testament)
     *
     * @return The part number, as denfined in
     *  (@link BibleBooks BibleBooks)
     */
    public byte getPart ()
    {
        return Utilities.getPartOfBook(_book);
    }

    /** The book identifier (absolute) */
    private byte _book;

    /**
     * The chapter identifier.
     *
     * This value is relative to the book.
     */
    private byte _chapter;

    /**
     * The vers identifier.
     *
     * This value is relative to the chapter.
     */
    private byte _vers;
}
