package de.jbible.bible;

/**
 * Contains the description string to a word.
 *
 * It contains the word index, relative to an here unknown text,
 * e.G. a vers this object belongs to, and the description string.
 * Objects of this type are immutable.
 */

public class WordDescription
{

    /**
     * Create a new object.
     *
     * @param index The word index
     * @param desc The description
     */
    public WordDescription(byte index,String desc)
    {
        _index = index;
        _desc = desc;
    }

    /** No default constructor.*/
    private WordDescription (){}

    /**
     * Access to the index.
     *
     * @return The index to the word to that this description belongs to
     */
    public byte getIndex ()
    {
        return _index;
    }

    /**
     * Access to the description.
     *
     * @return The description of the word.
     */
    public String getDescription ()
    {
        return _desc;
    }

    /** The index. */
    private byte _index;

    /** The description. */
    private String _desc;

}