package de.jbible.bible;

/**
 * This class contains a link to a vers from a word.
 *
 * The word is specified by the word index. The objects of this
 * type are not mutable.
 */

public class WordLink extends VersLocation
{
    /*
     * Create a new object.
     *
     * @param book The book index. (absulute)
     * @param chapter The chapter index (relative to the book)
     * @param vers The vers index (relative to the chaper)
     * @param wordIndex: The index of the word this link belongs to.
     *  If this value is -1, it belongs to the whole vers.
     *
     * @see BibleBooks
     */
    public WordLink(byte book,byte chapter,byte vers,byte wordIndex)
    {
        super (book,chapter,vers);
        _wordIndex = wordIndex;
    }

    /** Debug output. */
    public String toString ()
    {
        return "WordLink (P:"+getPart()+",B:"+getBook()+",C:"+getChapter()+",V:"+
            getVers()+",W:"+getWordIndex()+")";
    }

    /**
     * Access to the word index.
     *
     * If this value is -1, it belongs to the whole vers.
     *
     * @return The index to the word the link comes from.
     */
    public int getWordIndex ()
    {
        return _wordIndex;
    }

    /**
     * The index of the word from that this vers come from.
     *
     * If this value is -1, it belongs to the whole vers.
     */
    private byte _wordIndex;
}