package de.jbible.core;

import java.util.*;

/**
 * Interface of a bible tex provider service.
 *
 * A bible text provider service provides
 * {@link BibleText BibleText} objects.
 * The default implementaion of this interface
 * is the
 * {@link JBibleTextProvider JBibleTextProvider}
 */
public interface BibleTextProviderService extends Service
{
	/**
     * Return a list of the titles of all bibles that
     * are provided by this service.
     *
     * Dont cache this list because new bibles might be imported.
     *
     * @return The list of titles.
     */
	public String[] getTitles ();


    /**
     * Returns a bible.
     *
     * The request number correspondes to the order
     * of the array retured from the getTitles() method.
     *
     * @param index The index of the requested bible.
     * @return The requested bible.
     * @see #getTitles
     * @exception IndexOutOfBounds The index is not valid.
     */
	public BibleText getBible (int index);

}