package de.jbible.core;

/**
 * This interface must be implemented from services that
 * provide debug output service (e.G. in a window or in a file).
 *
 * It gets all error and logging messages from the logging manager.
 */
public interface DebugService extends Service
{
    /**
     * A debug message is sent.
     *
     * This method is called from the LoggingManager. With the type and location
     * information you can easily filter the messages you need.
     *
     * @param msg The message object to display
     */
    public void message (LogMessage msg);
}
