package de.jbible.core;

/**
 * This class can optional be used as baseclass of a service.
 * It handles some basic stuff as storing the context.
 * Default implementations of the required methods are
 * also provided.
 *
 * You can access the service context from the protected
 * variable {@link #_context _context}
 */
public class DefaultService implements Service
{
    /**
     * Store the context in this object.
     *
     * @param context The service context.
     */
    public void init(ServiceContext context)
    {
       _context = context;
    }

    /**
     * Nothing to do here.
     */
    public void exit()  {}

    /**
     * Nothing to do here.
     */
    public void start()  {}

    /** The service context. */
    protected ServiceContext _context;

    /**
     * Debug output.
     *
     * @return A description of this object.
     */
    public String toString()
    {
        return "DefaultService: " + this.getClass().toString();
    }
}
