package de.jbible.core;

import java.util.*;

/**
 * Listener to Locale changes.
 *
 * A service can implement this listener. It will be informed if
 * the locale of the program has changed.
 */
public interface LocaleChangeListener
{
    /**
     * This method is called if the locale has changed.
     *
     * The service should react on it and change all
     * its language dependend stuff.
     * <b>Important:</b> Dont call setLocale to the ServiceManager
     * or ServiceContext within this message!
     *
     * @see TheServiceManager
     * @param newLocale The new locale
     */
    public void localeChanged(Locale newLocale);
}
