package de.jbible.core;

/**
 * This object describe one logging message.
 *
 * The {@link de.jbible.core.LoggingManager  LoggingManager}
 * creates an instance of this object for each log and send it to
 * all services that implements the
 * {@link de.jbible.core.DebugService DebugService} interface.
 */
public class LogMessage
{

    /**
     * Create object and store data.
     *
     * @param msg The message string
     * @param location The location description. This must be a definition
     *  from Debug.
     * @param type The type of this message. This must be a definition
     *  from Debug.
     */
    public LogMessage(String msg,Object location,int type)
    {
        _msg = msg;
        _location = location;
        _type = type;
    }

    /**
     * Access to the message string.
     *
     * @return The message string
     */
    public String getMessage ()
    {
        return _msg;
    }

    /**
     * Access to the location description.
     *
     * @return The location description.
     */
    public String getLocation ()
    {
        if (_location == null)
            return "<Unknown>";
        return _location.getClass().getName();
    }

    /**
     * Access to the type
     *
     * @return The type, defined in
     *  {@link de.jbible.core.DebugService DebugService}
     */
    public int getType ()
    {
        return _type;
    }

    /**
     * For debugging.
     */
    public String toString()
    {
        String result="";

        if (_type == LoggingManager.MSG_ERROR)
            result = "!";

        return result+"<"+_location+"> "+_msg+"\n";
    }

    /** The message text.  */
    private String _msg;

    /** The location description. */
    private Object _location;

    /** The type of this message.  */
    private int _type;

}
