package de.jbible.core;

/**
 * This interface is used to communicate with a logging window.
 *
 * A window service must be able to provide a logging window.
 * Logging windows are used to log a process. After the process finished,
 * the ready () method must be called. Then the logging window enables a close
 * button.
 */
public interface LoggingWindowInterface
{
    /**
     * Log a message.
     *
     * @param msg The message that should be displayed.
     */
    public abstract void logMessage (String msg);

    /**
     * Log a warning.
     *
     * @param msg The message that should be displayed.
     */
    public abstract void logWarning (String msg);

    /**
     * Log an error.
     *
     * @param msg The message that should be displayed.
     */
    public abstract void logError (String msg);

    /**
     * The process has finished and the dialog can be closed now.
     */
    public abstract void ready ();

}
