package de.jbible.core;

/**
 * This is the interface of a faclility that visualize action which
 * takes several minutes.
 *
 * This interface is used e.G. for importing.
 *
 */
public interface ProgressWindowInterface
{
    /**
     * The user of the interface must call this method if the
     * action has finished.
     *
     * The facility can now display a close button instead of a progress bar.
     */
    public abstract void finished ();

    /**
     * Update the progress bar.
     *
     * @param percent The actual percentage of progress.
     */
    public abstract void setProgressValue (int percent);

    /**
     * Log a message.
     *
     * This could be a message, a warning or a error. The state give the
     * facility the opportunity to use different colors. Valid states are
     * {@link #WARNING WARNING)
     * {@link #MESSAGE MESSAGE)
     * {@link #ERROR ERROR}
     *
     * @param msg The message to log
     */
    public abstract void logMessage (String msg,int state);

    /** Message state for a normal message. */
    public static final int MESSAGE = 1;
    /** Message state for a warning. */
    public static final int WARNING = 2;
    /** Message state for an error. */
    public static final int ERROR = 3;

}