package de.jbible.core;

/**
 * This interface must be implemented from each Service.
 *
 * The modules are loaded and instanziated from the main method of JBible.
 * For definition of services see
 * {@link ServiceManager ServiceManager}
 *
 * @see ServiceManager
 * @see ServiceContext
 */
public interface Service
{
    /**
     * This method is called after the module is instanziated.
     *
     * Here you should add the GUI components you need. You can access the
     * facilities of the GUI and the other modules over the
     * {@link ServiceContext ServiceContext}.
     *
     * The service should register its  name and copyright here.
     * The default copyright is "Under GPL". Optional, a resource bundle.
     * can be registered. Note: A later registered resource bundle is only
     * used if a) the language or b) the PLAF is changed by the user.
     *
     * Dont create or make visible any GUI stuff here. Do this in the
     * {@link Service#start start} method.
     *
     * @param context The ServiceContext of this service
     * @see ServiceContext#registerName
     */
    public void init (ServiceContext context);


    /**
     * Start the application here.
     */
    public void start ();

    /**
     * This method is called before the application exits.
     *
     * You should write back data here.
     */
    public void exit ();

    /**
     * This method returns the name of the service.
     *
     * It's not localized.
     *
     * @return The name of the service
     */
 //   public String getName ();

    /**
     * This method returns the copyright of the service.
     *
     * This could be localised.
     *
     * @return The copyright of the service.
     */
//    public String getCopyright ();

    /**
     * Returns the resource bundle for this service.
     *
     * Each service can provide a resource bundle for
     * automatic translation of its GUI elements.
     *
     * @return The name of the resource bundle, relative to
     *  the classpath, separated with "/", if no Bundle is
     *  provided, the method must return null.
     */
//    public String getResourceBundle ();

}
