package de.jbible.core;

import java.util.*;

/**
 * This class is used to have a public interface to start an application.
 *
 * It just invokes TheServiceManager.
 *
 * <h2>Lifecycle of a service:</h2>
 *
 * <ol start="1" type="1">
 * <li>Created with the parameterless constructor</li>
 * <li>Call of <b>init ()</b> method. Register name, copyright and resources here
 *      dont create GUI stuff.</li>
 * <li>Call of <b>start ()</b> method. Create GUI stuff, start the app.</li>
 * </ol>
 */
public class ServiceManager
{
    /**
     * Invoke this method to start the ServiceManager.
     *
     * @param args The command line parameters
     */
    static public void start (String[] args)
    {
        new TheServiceManager (args);
    }

    /**
     * Access a static property.
     *
     * @param key The key of the value to retrieve.
     */
	public static String getStaticProperty (String key)
    {
    	return (String)_staticProps.get(key);
    }

    /**
     * Set a static property.
     *
     * @param key The key of the value.
     * @param value The value to store.
     */
	public static void setStaticProperty (String key,String value)
    {
    	_staticProps.put(key,value);
    }


    /**
     * Static property storage object.
     */
	private static Map _staticProps
    	= Collections.synchronizedMap(new HashMap ());


}

