package de.jbible.core;

import java.awt.*;
import java.awt.event.*;
/**
 * The interface for window services.
 *
 * A window service provides the main window for the application.
 * You can add your functions and the services provide them
 * to the user, e.G. in a menu and/or a tool bar.
 *
 * @see Service
 */

public interface WindowService extends Service
{
    /**
     * Registers an action.
     *
     * The action is added to the user interface, e.G. to the menu and/or
     * a tool bar. You must specify a action group, so that the Window
     * can put the action to the right position in the menu structure.
     *
     * @param name The name of the action This name is a refrence into the
     *      Ressource bundle.
     * @param group The group, see Group definitions below.
     * @param action The action that should be performed.
     * @param iconName Name of the icon for this action, must
     *  be relative to the classpath, with "/", e.G. "bible/bla/x.gif"
     * @param description A description of this action (key to the
     *  resource bundle), used for the status bar.
     *
     * @throws IllegalGroupException The group identifier is illegal or not
     *  supported by this service.
     *
     * @return true, if action was registered fine, else false
     */
    public boolean registerAction (String name,int group,
        ActionListener action,String iconName,String description)
        throws IllegalGroupException;

    /**
     * Creates a frame within the desktop.
     *
     * You must specify the name of the frame. What kind of object is
     * created depends on the GUI component. What you get is a component.
     * This might be the first container or a JInternalFrame ro whatever.
     * To get rid of the frame call the frame.setVisible (false) method
     * and remove it from its parent with :
     * frame.getParent().remove (frame)
     *
     * @param frameName The name of the frame.
     * @param content The content of the frame.
     * @param iconName Name of the icon for this action, must
     *  be relative to the classpath, with "/", e.G. "bible/bla/x.gif".
     * @param resizeable Is the frame resizable?
     *
     * @return You get the frame (or something like a frame) here.
     *
     * @see javax.swing.JComponent#getParent
     * @see java.awt.Container#remove
     */
    public Container createFrame (String frameName,Container content,
        String iconName,boolean resizeable);

    /**
     * Creates a modal dialog on the desktop.
     *
     * You must specify the name of the dialog. What kind of object is
     * created depends on the GUI component. What you get is a component.
     * This might be the first container or a JInternalFrame ro whatever.
     * To get rid of the dialog call the dialog.setVisible (false) method
     * and remove it from its parent with :
     * dialog.getParent().remove (dialog)
     *
     * @param dialogName The name of the dialog.
     * @param content The content of the dialog.
     * @param iconName Name of the icon for this action, must
     *  be relative to the classpath, with "/", e.G. "bible/bla/x.gif"
     *
     * @return You get the dialog (or something like a dialog) here.
     *
     * @see javax.swing.JComponent#getParent
     * @see java.awt.Container#remove
     */
    public Window createDialog (String frameName,Container content,
        String iconName);

    /**
     * Creates a logging window with optional progress bar.
     *
     * This method creates a frame with a logging area and optional
     * a progress bar. The idea is to have a facility that logs actions
     * that takes several minutes. The progress could be visualized with the
     * progress bar and with messages, warnings and errors. Its depends
     * on the returned window how the differences are visualzed.
     *
     * The user of this facility must call the finish method to show that
     * his action has finished. Then a close- button should be displayed.
     *
     * @return The created facility.
     */
    public ProgressWindowInterface createProgressWindow (String actionTitle,String iconName);

     /** Bible menu group. */
    public static final int GRP_BIBLE = 0;
    /** File menu group. */
    public static final int GRP_FILE = 1;
    /** Help menu group.  */
    public static final int GRP_HELP = 2;
    /** Group for functions like edit or search,... */
    public static final int GRP_EDIT = 3;
    /** Group for misc tools. */
    public static final int GRP_TOOLS = 4;
}
