package de.jbible.service.DebugWindow;

import de.jbible.*;
import de.jbible.core.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


/**
 * This service provides a Debug Output in a window.
 *
 * This service displays all messages broadcasted from
 * the {@link de.jbible.core.LoggingManager logging manager}
 * in a text area on the screen.
 */

public class DebugWindow extends DefaultService implements DebugService
{
     /**
     * This method is called after the module is instanziated.
     *
     * Here you should add the gui components you need. You can access the
     * facilities of the gui and the other modules over the
     * {@link de.jbible.core.ServiceContext ServiceContext}.
     *
     * @param context The ServiceContext of this service
     */
    public void init(ServiceContext context)
    {
        super.init(context);
        context.registerTitle("Debug Window Service");
    }

    /**
     * Create and show the debug window.
     */
    public void start ()
    {



        _scroll.getViewport().add(_area);
        // create main text area for logging:
        _frame.getContentPane().setLayout(new BorderLayout());
        _frame.getContentPane().add(_scroll,BorderLayout.CENTER);
        _frame.getContentPane().add (_monitor,BorderLayout.SOUTH);
        _monitor.surf.start();


        //_frame.getContentPane().add (_scroll);
		//_frame.getContentPane().add (fr);

        // Create menu
        JMenuBar bar = new JMenuBar ();

        // exit item:
        JMenu menu = new JMenu ("File");
        menu.setMnemonic ('F');
        JMenuItem item = new JMenuItem ("Quit");
        item.addActionListener (new ActionListener () {
            public void actionPerformed (ActionEvent ev)
            { doExit(); }});
        item.setAccelerator (KeyStroke.getKeyStroke('X',
            Event.CTRL_MASK));
        menu.add (item);
        bar.add (menu);

        _frame.setJMenuBar (bar);

        _frame.setBounds(0,0,400,300);
        _frame.setVisible (true);
    }

    /**
     * Exit command from user.
     */
    private void doExit ()
    {
        _context.exit(0);
    }

    /**
     * This method is called before the application exits.
     *
     * You should write back data here.
     */
    public void exit()
    {
        _frame.setVisible (false);
    }

    /**
     * A debug message is sent.
     *
     * This method is called from the LoggingManager. With the type and location
     * information you can easily filter the messages you need.
     *
     * @param msg The message object to display
     */
    public void message(LogMessage msg)
    {
       _area.append(msg.toString());
    }

    /** The area for the logging text. */
    private JTextArea _area = new JTextArea ();

    /** The scroll panel. */
    private JScrollPane _scroll = new JScrollPane ();

    /** Memory monitor: Tracks the memory usage. */
    private MemoryMonitor _monitor = new MemoryMonitor();

    /** The frame window.*/
    private JFrame _frame = new JFrame (Main.APP_TITLE+ " - Debug Window");
}

