package de.jbible.service.ImportDBG;

import java.io.*;

import de.jbible.core.*;
import de.jbible.bible.*;
/**
 * This is the import filter service for translations of the
 * Deutsche Bibelgesellschaft.
 */
public class ImportDBG extends DefaultService implements ImportFilterService
{

    /**
     * Returns the title(s) of the bible translation(s) this filter works with.
     *
     * A filter can handle more then one translation. These strings are keys
     * for translation.
     *
     * @return An array of titles.
     */
    public String[] getTranslationTitle ()
    {
        return _translations;
    }

    /**
     * Datatype that is imported by this filter.
     *
     * At this time there is only one data type: Bible Translation.
     * But there will be more types in the future, e.B. HTML Book
     *
     * @return An array with all datatypes of
     */
    public int [] getDataTypes ()
    {
        return _dataTypes;
    }

    /**
     * Returns the description of this filter.
     *
     * The text must describe how to use the filter. These strings are keys
     * for translation.
     *
     * @return An array of descriptions.
     */
    public String[] getDesription ()
    {
        return _translationDescriptions;
    }


    /**
     * Creates a BibleReaderObject that imports a bible translation
     * from given path/file.
     *
     * @param f The file that should be imported.
     * @param index The index of the selected import method
     * @exception IOException An io error might occure.
     * @return The Reader object that reads the translation.
     */
    public BibleImportReader createImportReader (File f,int index)
        throws IOException

    {
        switch (index)
        {
            case LUTHER84 :
                return new ImportLuther84 (f);
            default :
                LoggingManager.error("Wrong filter index in ImportDBG:"+index,
                    this);
                break;
        }
        return null;
    }



    /**
     * Returns a file filter for the search dialog.
     *
     * You must create a FileFilter, if you want to select a file.
     * If this method returns null, a path dialog is shown.
     *
     * @param index The index of the selected import method
     * @return The FileFilter object
     */
    public FileFilter getFileFilter (int index)
    {
        switch (index)
        {
            case LUTHER84 :
                return ImportLuther84.createFileFilter ();
            default :
                LoggingManager.error("Wrong filter index in ImportDBG:"+index,
                    this);
                break;
        }
        return null;
    }

    /**
     * Register name and resource bundle.
     *
     * @param context The ServiceContext of this service
     */
    public void init (ServiceContext context)
    {
        super.init(context);

        context.registerTitle("Importfilter for ASCII Bibles of the Deutsche Bibelgesellschaft.");
        context.registerResourceBundle("de.jbible.service.ImportDBG.ImportDBGResourceBundle");
    }

    /**
     * Access to a list of all files that belong to this translations.
     *
     * @param index The index of the selected import method
     * @return The list of all files for this translation
     */
    public Object[][] getFileList (int index)
    {
        // Create list:
        switch (index)
        {
            case LUTHER84 :
                return ImportLuther84.createFileList();
            default :
                LoggingManager.error("Wrong filter index in ImportDBG:"+index,
                    this);
                break;
        }
        return null;
    }


    /** Often used text in the translation names. */
    private static final String _trans1 = " ASCII Version";
    /**
     * The names of the supported translations.
     */
    private static final String [] _translations =
        {   "IDBGS_Luther1984_name",
            /*"IDBGS_Luther1915_name",
            "IDBGS_GuteNachricht_name"*/};

    /**
     * The descriptions of the supported translations.
     * These are language keys.
     */
    private static final String []_translationDescriptions =
        {   "IDBGS_Luther1984_desc",
            /*"IDBGS_Luther1915_desc",
            "IDBGS_GuteNachricht_desc"*/};

    /**
     * The datatypes of the supported translations
     */
    private static final int _dataTypes[] = {
        ImportFilterService.BIBLETRANSLATION,
        /*ImportFilterService.BIBLETRANSLATION,
        ImportFilterService.BIBLETRANSLATION,*/
        };


    /** Import define for Luther'84. */
    private static final int LUTHER84 = 0;

}
