package de.jbible.service.ImportDBG;

import java.util.*;

/**
 * Resource bundle for the Luther'84 import filter.
 *
 * This is german.
 */
public class ImportDBGResourceBundle_de extends ListResourceBundle
{
    /**
     * Returns the translation table.
     * Format : <Key>,<Value>
     *
     * @return The translation table.
     * @see java.util.ListResourceBundle
     */
    public Object[][] getContents()
    {
        return contents;
    }

    /** Ofen used substring.*/
    private static final String _desc1 =
        "Mit diesem Filter importieren Sie die ASCII-Version der Bibel \"";

    /** Ofen used substring.*/
    private static final String _desc2 =
        "\" importieren. "+
        "Dazu w\u00e4hlen Sie bitte " +
        "das Verzeichnis aus, in welchem sich die ASCII Dateien befinden. "+
        "bei einem Import von Diskette m\u00fcssen Sie w\u00e4hrend des Imports die "+
        "Diskette wechseln.";

    /** Often used text in the translation names. */
    private static final String _trans = " (Deutsch) ASCII Version";
    /**
     * The names of the supported translations.
     */
    private static final String [] _translations =
        { "Luther'1984"+_trans,"Luther 1915"+_trans,"Gute Nachricht"+_trans };


    private static final Object[][] contents =     {
        { "IDBGS_Luther1984_desc",_desc1 + "Luther'84" + _desc2 },
        { "IDBGS_Luther1915_desc",_desc1 + "Luther 1915" + _desc2 },
        { "IDBGS_GuteNachricht_desc",_desc1 + "Gute Nachricht" + _desc2 },
        { "IDBGS_Luther1984_name","Luther 1984"+_trans },
        { "IDBGS_Luther1915_name","Luther 1915"+_trans },
        { "IDBGS_GuteNachricht_name","Gute Nachricht"+_trans },
    };

}
