package de.jbible.service.ImportDBG;
import java.lang.System;
import java.io.*;
/**
 * This class makes the lexical analysis of
 * ASCII- Versions from the Deutsche Bibelgesellschaft.
 *
 * The final version of this class is generated by the JLex generator.
 */
class Utility {
  public static void assert
    (
     boolean expr
     )
      {
	if (false == expr) {
	  throw (new Error("Error: Assertion failed."));
	}
      }
  private static final String errorMsg[] = {
    "Error: Unmatched end-of-comment punctuation.",
    "Error: Unmatched start-of-comment punctuation.",
    "Error: Unclosed string.",
    "Error: Illegal character."
    };
  public static final int E_ENDCOMMENT = 0;
  public static final int E_STARTCOMMENT = 1;
  public static final int E_UNCLOSEDSTR = 2;
  public static final int E_UNMATCHED = 3;
  public static void error
    (
     int code
     )
      {
	System.out.println(errorMsg[code]);
      }
}


public class Yylex {
	private final int YY_BUFFER_SIZE = 512;
	private final int YY_F = -1;
	private final int YY_NO_STATE = -1;
	private final int YY_NOT_ACCEPT = 0;
	private final int YY_START = 1;
	private final int YY_END = 2;
	private final int YY_NO_ANCHOR = 4;
	private final char YY_EOF = '\uFFFF';
	private java.io.BufferedReader yy_reader;
	private int yy_buffer_index;
	private int yy_buffer_read;
	private int yy_buffer_start;
	private int yy_buffer_end;
	private char yy_buffer[];
	private int yyline;
	private int yy_lexical_state;

	public Yylex (java.io.Reader reader) {
		this ();
		if (null == reader) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_reader = new java.io.BufferedReader(reader);
	}

	public Yylex (java.io.InputStream instream) {
		this ();
		if (null == instream) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_reader = new java.io.BufferedReader(new java.io.InputStreamReader(instream));
	}

	private Yylex () {
		yy_buffer = new char[YY_BUFFER_SIZE];
		yy_buffer_read = 0;
		yy_buffer_index = 0;
		yy_buffer_start = 0;
		yy_buffer_end = 0;
		yyline = 0;
		yy_lexical_state = YYINITIAL;
	}

	private boolean yy_eof_done = false;
	private final int YYINITIAL = 0;
	private final int yy_state_dtrans[] = {
		0
	};
	private void yybegin (int state) {
		yy_lexical_state = state;
	}
	private char yy_advance ()
		throws java.io.IOException {
		int next_read;
		int i;
		int j;

		if (yy_buffer_index < yy_buffer_read) {
			return yy_buffer[yy_buffer_index++];
		}

		if (0 != yy_buffer_start) {
			i = yy_buffer_start;
			j = 0;
			while (i < yy_buffer_read) {
				yy_buffer[j] = yy_buffer[i];
				++i;
				++j;
			}
			yy_buffer_end = yy_buffer_end - yy_buffer_start;
			yy_buffer_start = 0;
			yy_buffer_read = j;
			yy_buffer_index = j;
			next_read = yy_reader.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YY_EOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}

		while (yy_buffer_index >= yy_buffer_read) {
			if (yy_buffer_index >= yy_buffer.length) {
				yy_buffer = yy_double(yy_buffer);
			}
			next_read = yy_reader.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YY_EOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}
		return yy_buffer[yy_buffer_index++];
	}
	private void yy_move_start () {
		if ((byte) '\n' == yy_buffer[yy_buffer_start]) {
			++yyline;
		}
		++yy_buffer_start;
	}
	private void yy_pushback () {
		--yy_buffer_end;
	}
	private void yy_mark_start () {
		int i;
		for (i = yy_buffer_start; i < yy_buffer_index; ++i) {
			if ((byte) '\n' == yy_buffer[i]) {
				++yyline;
			}
		}
		yy_buffer_start = yy_buffer_index;
	}
	private void yy_mark_end () {
		yy_buffer_end = yy_buffer_index;
	}
	private void yy_to_mark () {
		yy_buffer_index = yy_buffer_end;
	}
	private java.lang.String yytext () {
		return (new java.lang.String(yy_buffer,
			yy_buffer_start,
			yy_buffer_end - yy_buffer_start));
	}
	private int yylength () {
		return yy_buffer_end - yy_buffer_start;
	}
	private char[] yy_double (char buf[]) {
		int i;
		char newbuf[];
		newbuf = new char[2*buf.length];
		for (i = 0; i < buf.length; ++i) {
			newbuf[i] = buf[i];
		}
		return newbuf;
	}
	private final int YY_E_INTERNAL = 0;
	private final int YY_E_MATCH = 1;
	private java.lang.String yy_error_string[] = {
		"Error: Internal error.\n",
		"Error: Unmatched input.\n"
	};
	private void yy_error (int code,boolean fatal) {
		java.lang.System.out.print(yy_error_string[code]);
		java.lang.System.out.flush();
		if (fatal) {
			throw new Error("Fatal Error.\n");
		}
	}
private int [][] unpackFromString(int size1, int size2, String st)
    {
      int colonIndex = -1;
      String lengthString;
      int sequenceLength = 0;
      int sequenceInteger = 0;
      int commaIndex;
      String workString;
      int res[][] = new int[size1][size2];
      for (int i= 0; i < size1; i++)
	for (int j= 0; j < size2; j++)
	  {
	    if (sequenceLength == 0) 
	      {	
		commaIndex = st.indexOf(',');
		if (commaIndex == -1)
		  workString = st;
		else
		  workString = st.substring(0, commaIndex);
		st = st.substring(commaIndex+1);
		colonIndex = workString.indexOf(':');
		if (colonIndex == -1)
		  {
		    res[i][j] = Integer.parseInt(workString);
		  }
		else 
		  {
		    lengthString = workString.substring(colonIndex+1);  
		    sequenceLength = Integer.parseInt(lengthString);
		    workString = workString.substring(0,colonIndex);
		    sequenceInteger = Integer.parseInt(workString);
		    res[i][j] = sequenceInteger;
		    sequenceLength--;
		  }
	      }
	    else 
	      {
		res[i][j] = sequenceInteger;
		sequenceLength--;
	      }
	  }
      return res;
    }
	private final int yy_acpt[] = {
		YY_NOT_ACCEPT,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NOT_ACCEPT,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NOT_ACCEPT,
		YY_NO_ANCHOR,
		YY_NOT_ACCEPT,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR
	};
	private final int yy_cmap[] = {
		0, 0, 0, 0, 0, 0, 0, 0,
		1, 1, 1, 0, 0, 1, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 1, 0, 0, 0, 0, 0,
		2, 3, 0, 0, 0, 0, 0, 3,
		4, 5, 6, 0, 3, 3, 3, 3,
		7, 7, 7, 7, 7, 7, 7, 7,
		7, 7, 3, 3, 0, 3, 0, 3,
		0, 8, 9, 10, 10, 10, 10, 10,
		10, 10, 10, 11, 10, 10, 10, 10,
		12, 10, 10, 13, 10, 14, 15, 10,
		10, 10, 16, 3, 0, 3, 0, 17,
		0, 18, 18, 18, 18, 18, 18, 18,
		18, 18, 18, 18, 18, 18, 18, 18,
		18, 18, 18, 18, 18, 18, 18, 18,
		18, 18, 18, 0, 19, 0, 3, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 3, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 3, 0, 0, 0, 0,
		0, 0, 0, 0, 10, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 10, 0,
		0, 0, 0, 0, 10, 0, 0, 10,
		0, 0, 0, 0, 10, 0, 0, 0,
		0, 0, 0, 10, 0, 0, 0, 10,
		0, 0, 0, 0, 0, 0, 10, 0,
		0, 0, 0, 0, 10, 0, 0, 0,
		0 
	};
	private final int yy_rmap[] = {
		0, 1, 2, 3, 4, 5, 2, 2,
		2, 2, 2, 2, 2, 2, 2, 2,
		2, 2, 2, 2, 2, 2, 6, 7,
		8, 9, 10, 11, 12, 13, 14 
	};
	private final int yy_nxt[][] = unpackFromString(15,20,
"-1,1:2,2,23,2,3,4,5,24:3,26,28,29,24,30,-1,24,22,-1,1:2,-1:43,6,-1:20,4,-1:19,24:12,7,-1:8,12,13,-1,14,15,16,17,18,19,-1:21,25,-1:8,24:12,-1:6,20,-1:21,24:12,8,-1:19,21,-1:7,24:12,9,-1:2,27,-1:4,24:12,10,-1:7,24:12,11");
	public Yytoken yylex ()
		throws java.io.IOException {
		char yy_lookahead;
		int yy_anchor = YY_NO_ANCHOR;
		int yy_state = yy_state_dtrans[yy_lexical_state];
		int yy_next_state = YY_NO_STATE;
		int yy_last_accept_state = YY_NO_STATE;
		boolean yy_initial = true;
		int yy_this_accept;

		yy_mark_start();
		yy_this_accept = yy_acpt[yy_state];
		if (YY_NOT_ACCEPT != yy_this_accept) {
			yy_last_accept_state = yy_state;
			yy_mark_end();
		}
		while (true) {
			yy_lookahead = yy_advance();
			yy_next_state = YY_F;
			if (YY_EOF != yy_lookahead) {
				yy_next_state = yy_nxt[yy_rmap[yy_state]][yy_cmap[yy_lookahead]];
			}
			if (YY_F != yy_next_state) {
				yy_state = yy_next_state;
				yy_initial = false;
				yy_this_accept = yy_acpt[yy_state];
				if (YY_NOT_ACCEPT != yy_this_accept) {
					yy_last_accept_state = yy_state;
					yy_mark_end();
				}
			}
			else {
				if (YY_EOF == yy_lookahead && true == yy_initial) {

	yy_reader.close();
	return new Yytoken (ImportDBGParser.EOF,"",yyline);
				}
				else if (YY_NO_STATE == yy_last_accept_state) {
					throw (new Error("Lexical Error:(Line "+yyline+") Unmatched Input: 0x"+Integer.toHexString((int)yy_lookahead)+" "+(int)yy_lookahead+" >"+yy_lookahead+"<"));
				}
				else {
					yy_to_mark();
					yy_anchor = yy_acpt[yy_last_accept_state];
					if (0 != (YY_END & yy_anchor)) {
						yy_pushback();
					}
					if (0 != (YY_START & yy_anchor)) {
						yy_move_start();
					}
					switch (yy_last_accept_state) {
					case 1:
						{}
					case -2:
						break;
					case 2:
						{ return (new Yytoken(ImportDBGParser.WORD,yytext(),yyline)); }
					case -3:
						break;
					case 3:
						{ return (new Yytoken(ImportDBGParser.COMMENT_MARKER,"*",yyline)); }
					case -4:
						break;
					case 4:
						{ return (new Yytoken(ImportDBGParser.NUMBER,yytext(),yyline)); }
					case -5:
						break;
					case 5:
						{ return (new Yytoken(ImportDBGParser.WORD,yytext(),yyline)); }
					case -6:
						break;
					case 6:
						{ return (new Yytoken(ImportDBGParser.COMMENT_MARKER,"**",yyline)); }
					case -7:
						break;
					case 7:
						{ return (new Yytoken(ImportDBGParser.END_PARAGRAPH_PARALLEL,yyline)); }
					case -8:
						break;
					case 8:
						{ return (new Yytoken(ImportDBGParser.END_WORD_PARALLEL,yyline)); }
					case -9:
						break;
					case 9:
						{ return (new Yytoken(ImportDBGParser.END_EXPLANATION,yyline)); }
					case -10:
						break;
					case 10:
						{ return (new Yytoken(ImportDBGParser.END_HEADLINE,yyline)); }
					case -11:
						break;
					case 11:
						{ return (new Yytoken(ImportDBGParser.END_COMMENT,yyline)); }
					case -12:
						break;
					case 12:
						{ return (new Yytoken(ImportDBGParser.START_PARAGRAPH_PARALLEL,yyline)); }
					case -13:
						break;
					case 13:
						{ return (new Yytoken(ImportDBGParser.BOOK,yyline)); }
					case -14:
						break;
					case 14:
						{ return (new Yytoken(ImportDBGParser.CHAPTER,yyline)); }
					case -15:
						break;
					case 15:
						{ return (new Yytoken(ImportDBGParser.START_WORD_PARALLEL,yyline)); }
					case -16:
						break;
					case 16:
						{ return (new Yytoken(ImportDBGParser.START_EXPLANATION,yyline)); }
					case -17:
						break;
					case 17:
						{ return (new Yytoken(ImportDBGParser.START_HEADLINE,yyline)); }
					case -18:
						break;
					case 18:
						{ return (new Yytoken(ImportDBGParser.VERS,yyline)); }
					case -19:
						break;
					case 19:
						{ return (new Yytoken(ImportDBGParser.START_COMMENT,yyline)); }
					case -20:
						break;
					case 20:
						{ return (new Yytoken(ImportDBGParser.PARALLEL_MARKER,yytext(),yyline)); }
					case -21:
						break;
					case 21:
						{ return (new Yytoken(ImportDBGParser.END_HEADLINE,yyline)); }
					case -22:
						break;
					case 23:
						{ return (new Yytoken(ImportDBGParser.WORD,yytext(),yyline)); }
					case -23:
						break;
					case 24:
						{ return (new Yytoken(ImportDBGParser.WORD,yytext(),yyline)); }
					case -24:
						break;
					case 26:
						{ return (new Yytoken(ImportDBGParser.WORD,yytext(),yyline)); }
					case -25:
						break;
					case 28:
						{ return (new Yytoken(ImportDBGParser.WORD,yytext(),yyline)); }
					case -26:
						break;
					case 29:
						{ return (new Yytoken(ImportDBGParser.WORD,yytext(),yyline)); }
					case -27:
						break;
					case 30:
						{ return (new Yytoken(ImportDBGParser.WORD,yytext(),yyline)); }
					case -28:
						break;
					default:
						yy_error(YY_E_INTERNAL,false);
					case -1:
					}
					yy_initial = true;
					yy_state = yy_state_dtrans[yy_lexical_state];
					yy_next_state = YY_NO_STATE;
					yy_last_accept_state = YY_NO_STATE;
					yy_mark_start();
					yy_this_accept = yy_acpt[yy_state];
					if (YY_NOT_ACCEPT != yy_this_accept) {
						yy_last_accept_state = yy_state;
					}
				}
			}
		}
	}
}
